/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jasig.portal.portlet.container.cache.CachedPortletResultHolder;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;

public class CachedPortletData<T extends Serializable>
implements CachedPortletResultHolder<T>,
Serializable {
    private static final long serialVersionUID = 5509299103587289000L;
    private final T portletResult;
    private final String cachedWriterOutput;
    private final byte[] cachedStreamOutput;
    private final String contentType;
    private final boolean publicScope;
    private final String etag;
    private final long timeStored;
    private long expirationTime;

    public CachedPortletData(T portletResult, String cachedWriterOutput, byte[] cachedStreamOutput, String contentType, boolean publicScope, String etag, int expirationTime) {
        if (cachedWriterOutput != null && cachedStreamOutput != null) {
            throw new IllegalArgumentException("Both cachedWriterOutput and cachedStreamOutput have been specified");
        }
        this.portletResult = portletResult;
        this.cachedWriterOutput = cachedWriterOutput;
        this.cachedStreamOutput = cachedStreamOutput;
        this.contentType = contentType;
        this.publicScope = publicScope;
        this.etag = etag;
        this.timeStored = System.currentTimeMillis();
        this.updateExpirationTime(expirationTime);
    }

    public void replay(PortletOutputHandler portletOutputHandler) throws IOException {
        if (this.contentType != null) {
            portletOutputHandler.setContentType(this.contentType);
        }
        if (this.cachedWriterOutput != null) {
            PrintWriter printWriter = portletOutputHandler.getPrintWriter();
            printWriter.write(this.cachedWriterOutput);
        } else if (this.cachedStreamOutput != null) {
            OutputStream outputStream = portletOutputHandler.getOutputStream();
            outputStream.write(this.cachedStreamOutput);
        }
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void updateExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime == -1 ? -1L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expirationTime);
    }

    public T getPortletResult() {
        return (T)this.portletResult;
    }

    public String getCachedWriterOutput() {
        return this.cachedWriterOutput;
    }

    public byte[] getCachedStreamOutput() {
        return this.cachedStreamOutput;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getTimeStored() {
        return this.timeStored;
    }

    public boolean isPublicScope() {
        return this.publicScope;
    }
}

