/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.container.cache.CachedPortletResultHolder;
import org.jasig.portal.portlet.container.cache.PortletCachingHeaderUtils;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;

public class CachedPortletResourceData<T extends Serializable>
implements CachedPortletResultHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CachedPortletData<T> cachedPortletData;
    private final Map<String, List<Serializable>> headers;
    private final Integer status;
    private final String characterEncoding;
    private final Integer contentLength;
    private final Locale locale;

    public CachedPortletResourceData(CachedPortletData<T> cachedPortletData, Map<String, List<Serializable>> headers, Integer status, String characterEncoding, Integer contentLength, Locale locale) {
        this.cachedPortletData = cachedPortletData;
        ImmutableMap.Builder headersBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<Serializable>> headerEntry : headers.entrySet()) {
            String name = headerEntry.getKey();
            List<Serializable> values = headerEntry.getValue();
            headersBuilder.put((Object)name, (Object)ImmutableList.copyOf(values));
        }
        this.headers = headersBuilder.build();
        this.status = status;
        this.characterEncoding = characterEncoding;
        this.contentLength = contentLength;
        this.locale = locale;
    }

    public final void replay(PortletResourceOutputHandler portletOutputHandler) throws IOException {
        if (this.status != null) {
            portletOutputHandler.setStatus(this.status.intValue());
        }
        for (Map.Entry headerEntry : this.headers.entrySet()) {
            String name = (String)headerEntry.getKey();
            for (Serializable value : (List)headerEntry.getValue()) {
                if (value instanceof Long) {
                    portletOutputHandler.addDateHeader(name, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Long) {
                    portletOutputHandler.addIntHeader(name, ((Integer)value).intValue());
                    continue;
                }
                portletOutputHandler.addHeader(name, (String)((Object)value));
            }
        }
        if (this.characterEncoding != null) {
            portletOutputHandler.setCharacterEncoding(this.characterEncoding);
        }
        if (this.contentLength != null) {
            portletOutputHandler.setContentLength(this.contentLength.intValue());
        }
        if (this.locale != null) {
            portletOutputHandler.setLocale(this.locale);
        }
        PortletCachingHeaderUtils.setCachingHeaders((CachedPortletData)this.cachedPortletData, (PortletResourceOutputHandler)portletOutputHandler);
        this.cachedPortletData.replay((PortletOutputHandler)portletOutputHandler);
    }

    public T getPortletResult() {
        return (T)this.cachedPortletData.getPortletResult();
    }

    public long getExpirationTime() {
        return this.cachedPortletData.getExpirationTime();
    }

    public String getEtag() {
        return this.cachedPortletData.getEtag();
    }

    public long getTimeStored() {
        return this.cachedPortletData.getTimeStored();
    }

    public CachedPortletData<T> getCachedPortletData() {
        return this.cachedPortletData;
    }

    public Map<String, List<Serializable>> getHeaders() {
        return this.headers;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Integer getContentLength() {
        return this.contentLength;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

