/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import com.google.common.base.Function;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import javax.portlet.CacheControl;
import org.apache.commons.io.output.StringBuilderWriter;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.container.cache.LimitingTeeOutputStream;
import org.jasig.portal.portlet.container.cache.LimitingTeeWriter;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;

public class CachingPortletOutputHandler
implements PortletOutputHandler {
    private final PortletOutputHandler portletOutputHandler;
    private final int maximumSize;
    private LimitingTeeWriter teeWriter;
    private PrintWriter printWriter;
    private LimitingTeeOutputStream teeStream;
    private StringBuilderWriter cachingWriter;
    private ByteArrayOutputStream cachingOutputStream;
    private String contentType;

    public CachingPortletOutputHandler(PortletOutputHandler portletOutputHandler, int maximumSize) {
        this.portletOutputHandler = portletOutputHandler;
        this.maximumSize = maximumSize;
    }

    public <T extends Serializable> CachedPortletData<T> getCachedPortletData(T portletResult, CacheControl cacheControl) {
        if (this.teeWriter != null && this.teeWriter.isLimitReached() || this.teeStream != null && this.teeStream.isLimitReached()) {
            return null;
        }
        return new CachedPortletData(portletResult, this.cachingWriter != null ? this.cachingWriter.toString() : null, this.cachingOutputStream != null ? this.cachingOutputStream.toByteArray() : null, this.contentType, cacheControl.isPublicScope(), cacheControl.getETag(), cacheControl.getExpirationTime());
    }

    public String getCachedWriterOutput() {
        if (this.cachingWriter == null) {
            return null;
        }
        return this.cachingWriter.toString();
    }

    public byte[] getCachedStreamOutput() {
        if (this.cachingOutputStream == null) {
            return null;
        }
        return this.cachingOutputStream.toByteArray();
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (this.teeStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called");
        }
        if (this.printWriter == null) {
            PrintWriter delegateWriter = this.portletOutputHandler.getPrintWriter();
            this.cachingWriter = new StringBuilderWriter();
            this.teeWriter = new LimitingTeeWriter((long)this.maximumSize, (Writer)delegateWriter, (Writer)this.cachingWriter, (Function)new /* Unavailable Anonymous Inner Class!! */);
            this.printWriter = new PrintWriter((Writer)this.teeWriter);
        }
        return this.printWriter;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("getPrintWriter() has already been called");
        }
        if (this.teeStream == null) {
            OutputStream delegateOutputStream = this.portletOutputHandler.getOutputStream();
            this.cachingOutputStream = new ByteArrayOutputStream();
            this.teeStream = new LimitingTeeOutputStream((long)this.maximumSize, delegateOutputStream, (OutputStream)this.cachingOutputStream, (Function)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.teeStream;
    }

    public void flushBuffer() throws IOException {
        this.portletOutputHandler.flushBuffer();
    }

    public int getBufferSize() {
        return this.portletOutputHandler.getBufferSize();
    }

    public boolean isCommitted() {
        return this.portletOutputHandler.isCommitted();
    }

    public void reset() {
        this.portletOutputHandler.reset();
        this.resetCached();
    }

    public void resetBuffer() {
        this.portletOutputHandler.resetBuffer();
        this.resetCached();
    }

    private void resetCached() {
        this.resetCachedWriter();
        this.resetCachedStream();
    }

    private void resetCachedWriter() {
        if (this.cachingWriter != null) {
            this.teeWriter.resetByteCount();
            this.clearCachedWriter();
        }
    }

    private void clearCachedWriter() {
        StringBuilder builder;
        if (this.cachingWriter != null && (builder = this.cachingWriter.getBuilder()).length() > 0) {
            builder.delete(0, builder.length());
        }
    }

    private void resetCachedStream() {
        if (this.cachingOutputStream != null) {
            this.teeStream.resetByteCount();
            this.clearCachedStream();
        }
    }

    private void clearCachedStream() {
        if (this.cachingOutputStream != null) {
            this.cachingOutputStream.reset();
        }
    }

    public void setBufferSize(int size) {
        this.portletOutputHandler.setBufferSize(size);
    }

    public void setContentType(String contentType) {
        this.portletOutputHandler.setContentType(contentType);
        this.contentType = contentType;
    }

    static /* synthetic */ void access$000(CachingPortletOutputHandler x0) {
        x0.clearCachedWriter();
    }

    static /* synthetic */ void access$100(CachingPortletOutputHandler x0) {
        x0.clearCachedStream();
    }
}

