/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.jasig.portal.utils.TeeOutputStream;

public class LimitingTeeOutputStream
extends TeeOutputStream {
    private final long maximumBytes;
    private final OutputStream branch;
    private final Function<LimitingTeeOutputStream, ?> limitReachedCallback;
    private long byteCount = 0L;
    private boolean limitReached = false;

    public LimitingTeeOutputStream(long maximumBytes, OutputStream out, OutputStream branch) {
        this(maximumBytes, out, branch, null);
    }

    public LimitingTeeOutputStream(long maximumBytes, OutputStream out, OutputStream branch, Function<LimitingTeeOutputStream, ?> limitReachedCallback) {
        super(out, branch);
        this.maximumBytes = maximumBytes;
        this.branch = branch;
        this.limitReachedCallback = limitReachedCallback;
    }

    public void resetByteCount() {
        this.byteCount = 0L;
        if (this.limitReached) {
            this.limitReached = false;
            this.setBranch(this.branch);
        }
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    protected void beforeWrite(int n) throws IOException {
        this.byteCount += (long)n;
        if (this.maximumBytes > 0L && !this.limitReached && this.byteCount > this.maximumBytes) {
            this.limitReached = true;
            this.setBranch((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            if (this.limitReachedCallback != null) {
                this.limitReachedCallback.apply((Object)this);
            }
        }
    }
}

