/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.NullWriter;
import org.jasig.portal.utils.TeeWriter;

public class LimitingTeeWriter
extends TeeWriter {
    private final long maximumCharacters;
    private final Writer branch;
    private final Function<LimitingTeeWriter, ?> limitReachedCallback;
    private long characterCount = 0L;
    private boolean limitReached = false;

    public LimitingTeeWriter(long maximumCharacters, Writer out, Writer branch) {
        this(maximumCharacters, out, branch, null);
    }

    public LimitingTeeWriter(long maximumCharacters, Writer out, Writer branch, Function<LimitingTeeWriter, ?> limitReachedCallback) {
        super(out, branch);
        this.maximumCharacters = maximumCharacters;
        this.branch = branch;
        this.limitReachedCallback = limitReachedCallback;
    }

    public void resetByteCount() {
        this.characterCount = 0L;
        if (this.limitReached) {
            this.limitReached = false;
            this.setBranch(this.branch);
        }
    }

    public long getCharacterCount() {
        return this.characterCount;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    protected void beforeWrite(int n) throws IOException {
        this.characterCount += (long)n;
        if (this.maximumCharacters > 0L && !this.limitReached && this.characterCount > this.maximumCharacters) {
            this.limitReached = true;
            this.setBranch((Writer)NullWriter.NULL_WRITER);
            if (this.limitReachedCallback != null) {
                this.limitReachedCallback.apply((Object)this);
            }
        }
    }
}

