/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.SimpleCacheEntryTag;
import org.jasig.portal.utils.cache.TaggedCacheEntry;

/*
 * Exception performing whole class analysis ignored.
 */
public class PublicPortletCacheKey
implements Serializable,
TaggedCacheEntry {
    private static final String PORTLET_DEFINITION_ID_CACHE_ENTRY_TAG_NAME = PublicPortletCacheKey.class.getName() + ".PORTLET_DEFINITION_ID";
    private static final long serialVersionUID = 1L;
    private final IPortletDefinitionId portletDefinitionId;
    private final Map<String, List<String>> parameters;
    private final boolean renderHeader;
    private final String resourceId;
    private final Locale locale;
    private final String windowState;
    private final String portletMode;
    private final Set<CacheEntryTag> cacheEntryTags;
    private final int hash;

    static PublicPortletCacheKey createPublicPortletRenderCacheKey(IPortletWindow portletWindow, IPortalRequestInfo portalRequestInfo, Locale locale) {
        return new PublicPortletCacheKey(portletWindow, portalRequestInfo, false, locale);
    }

    static PublicPortletCacheKey createPublicPortletRenderHeaderCacheKey(IPortletWindow portletWindow, IPortalRequestInfo portalRequestInfo, Locale locale) {
        return new PublicPortletCacheKey(portletWindow, portalRequestInfo, true, locale);
    }

    static PublicPortletCacheKey createPublicPortletResourceCacheKey(IPortletWindow portletWindow, IPortalRequestInfo portalRequestInfo, Locale locale) {
        return new PublicPortletCacheKey(portletWindow, portalRequestInfo, false, locale);
    }

    private PublicPortletCacheKey(IPortletWindow portletWindow, IPortalRequestInfo portalRequestInfo, boolean renderHeader, Locale locale) {
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        this.portletDefinitionId = portletEntity.getPortletDefinitionId();
        WindowState reqWindowState = null;
        PortletMode reqPortletMode = null;
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getPortletRequestInfo(portletWindow.getPortletWindowId());
        if (portletRequestInfo != null) {
            this.parameters = portletRequestInfo.getPortletParameters();
            reqWindowState = portletRequestInfo.getWindowState();
            reqPortletMode = portletRequestInfo.getPortletMode();
        } else {
            this.parameters = portalRequestInfo.getUrlType() == UrlType.RENDER ? ParameterMap.convertArrayMap((Map)portletWindow.getRenderParameters()) : Collections.emptyMap();
        }
        this.resourceId = portalRequestInfo.getUrlType() == UrlType.RESOURCE ? portletRequestInfo.getResourceId() : null;
        this.windowState = reqWindowState == null ? portletWindow.getWindowState().toString() : reqWindowState.toString();
        this.portletMode = reqPortletMode == null ? portletWindow.getPortletMode().toString() : reqPortletMode.toString();
        this.renderHeader = renderHeader;
        this.locale = locale;
        this.cacheEntryTags = Collections.singleton(PublicPortletCacheKey.createTag((IPortletDefinitionId)this.portletDefinitionId));
        this.hash = this.internalHashCode();
    }

    public static CacheEntryTag createTag(IPortletDefinitionId definitionId) {
        return new SimpleCacheEntryTag(PORTLET_DEFINITION_ID_CACHE_ENTRY_TAG_NAME, (Object)definitionId);
    }

    public Set<CacheEntryTag> getTags() {
        return this.cacheEntryTags;
    }

    public IPortletDefinitionId getPortletDefinitionId() {
        return this.portletDefinitionId;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public boolean isRenderHeader() {
        return this.renderHeader;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public int hashCode() {
        return this.hash;
    }

    private int internalHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.portletDefinitionId == null ? 0 : this.portletDefinitionId.hashCode());
        result = 31 * result + (this.portletMode == null ? 0 : this.portletMode.hashCode());
        result = 31 * result + (this.renderHeader ? 1231 : 1237);
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.windowState == null ? 0 : this.windowState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicPortletCacheKey other = (PublicPortletCacheKey)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.portletDefinitionId == null ? other.portletDefinitionId != null : !this.portletDefinitionId.equals(other.portletDefinitionId)) {
            return false;
        }
        if (this.portletMode == null ? other.portletMode != null : !this.portletMode.equals(other.portletMode)) {
            return false;
        }
        if (this.renderHeader != other.renderHeader) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        return !(this.windowState == null ? other.windowState != null : !this.windowState.equals(other.windowState));
    }

    public String toString() {
        if (this.renderHeader) {
            return "PublicPortletRenderHeaderCacheKey [portletDefinitionId=" + this.portletDefinitionId + ", parameters=" + this.parameters + ", locale=" + this.locale + ", windowState=" + this.windowState + ", portletMode=" + this.portletMode + "]";
        }
        if (this.resourceId != null) {
            return "PublicPortletResourceCacheKey [portletDefinitionId=" + this.portletDefinitionId + ", parameters=" + this.parameters + ", resourceId=" + this.resourceId + ", locale=" + this.locale + ", windowState=" + this.windowState + ", portletMode=" + this.portletMode + "]";
        }
        return "PublicPortletRenderCacheKey [portletDefinitionId=" + this.portletDefinitionId + ", parameters=" + this.parameters + ", locale=" + this.locale + ", windowState=" + this.windowState + ", portletMode=" + this.portletMode + "]";
    }
}

