/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.properties;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.portlet.container.properties.BaseRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.utils.Populator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="httpRequestPropertiesManager")
public class HttpRequestPropertiesManager
extends BaseRequestPropertiesManager {
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public <P extends Populator<String, String>> void populateRequestProperties(HttpServletRequest portletRequest, IPortletWindow portletWindow, P propertiesPopulator) {
        String method;
        String remoteHost;
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortalRequest(portletRequest);
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (remoteAddr != null) {
            propertiesPopulator.put((Object)"REMOTE_ADDR", (Object)remoteAddr);
        }
        if ((remoteHost = httpServletRequest.getRemoteHost()) != null) {
            propertiesPopulator.put((Object)"REMOTE_HOST", (Object)remoteHost);
        }
        if ((method = httpServletRequest.getMethod()) != null) {
            propertiesPopulator.put((Object)"REQUEST_METHOD", (Object)method);
        }
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration values = httpServletRequest.getHeaders(name);
            while (values.hasMoreElements()) {
                propertiesPopulator.put((Object)name, values.nextElement());
            }
        }
    }
}

