/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.properties;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.portlet.container.properties.BaseRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.utils.Populator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyToAttributePropertiesManager
extends BaseRequestPropertiesManager {
    private IPortalRequestUtils portalRequestUtils;
    private BiMap<String, String> propertyToAttributeMappings = ImmutableBiMap.of();
    private BiMap<String, String> attributeToPropertyMappings = ImmutableBiMap.of();
    private Set<String> nonNamespacedProperties = Collections.emptySet();

    @Resource(name="portletPropertyToAttributeMappings")
    public void setPropertyMappings(Map<String, String> propertyMappings) {
        this.propertyToAttributeMappings = ImmutableBiMap.copyOf(propertyMappings);
        this.attributeToPropertyMappings = this.propertyToAttributeMappings.inverse();
    }

    @Resource(name="nonNamespacedPortletProperties")
    public void setNonNamespacedProperties(Set<String> nonNamespacedProperties) {
        this.nonNamespacedProperties = ImmutableSet.copyOf(nonNamespacedProperties);
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public boolean addResponseProperty(HttpServletRequest portletRequest, IPortletWindow portletWindow, String property, String value) {
        String attributeName;
        if (this.propertyToAttributeMappings.isEmpty() && this.nonNamespacedProperties.isEmpty()) {
            return false;
        }
        HttpServletRequest portalRequest = this.portalRequestUtils.getOriginalPortalRequest(portletRequest);
        Object existingValue = portalRequest.getAttribute(attributeName = this.getAttributeName(portletWindow, property));
        if (!(existingValue instanceof List)) {
            this.logger.warn("Attribute {} for property {} exists but is NOT a List, it will be replaced", (Object)attributeName, (Object)property);
            this.setResponseProperty(portletRequest, portletWindow, property, value);
            return true;
        }
        this.logger.debug("Adding property {} as attribute {}", (Object)property, (Object)attributeName);
        List values = (List)existingValue;
        values.add(value);
        portalRequest.setAttribute(attributeName, (Object)values);
        return true;
    }

    public boolean setResponseProperty(HttpServletRequest portletRequest, IPortletWindow portletWindow, String property, String value) {
        if (this.propertyToAttributeMappings.isEmpty() && this.nonNamespacedProperties.isEmpty()) {
            return false;
        }
        HttpServletRequest portalRequest = this.portalRequestUtils.getOriginalPortalRequest(portletRequest);
        String attributeName = this.getAttributeName(portletWindow, property);
        this.logger.debug("Setting property {} as attribute {}", (Object)property, (Object)attributeName);
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        portalRequest.setAttribute(attributeName, values);
        return true;
    }

    protected String getAttributeName(IPortletWindow portletWindow, String property) {
        String mappedAttributeName = (String)this.propertyToAttributeMappings.get((Object)property);
        String attributeName = mappedAttributeName == null ? property : mappedAttributeName;
        if (this.nonNamespacedProperties.contains(property)) {
            return attributeName;
        }
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        return portletWindowId.getStringId() + attributeName;
    }

    public <P extends Populator<String, String>> void populateRequestProperties(HttpServletRequest portletRequest, IPortletWindow portletWindow, P propertiesPopulator) {
        if (this.propertyToAttributeMappings.isEmpty() && this.nonNamespacedProperties.isEmpty()) {
            return;
        }
        HttpServletRequest portalRequest = this.portalRequestUtils.getOriginalPortalRequest(portletRequest);
        String windowIdStr = portletWindow.getPortletWindowId().getStringId();
        Enumeration attributeNames = portalRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String fullAttributeName = (String)attributeNames.nextElement();
            String propertyName = this.getPropertyName(windowIdStr, fullAttributeName);
            if (propertyName == null) continue;
            this.logger.debug("Found portal request attribute {} returning as property {}", (Object)fullAttributeName, (Object)propertyName);
            Object value = portalRequest.getAttribute(fullAttributeName);
            this.convertValue(propertyName, value, propertiesPopulator);
        }
    }

    private String getPropertyName(String windowIdStr, String fullAttributeName) {
        String attributeName;
        if (this.nonNamespacedProperties.contains(fullAttributeName)) {
            attributeName = fullAttributeName;
        } else if (fullAttributeName.startsWith(windowIdStr)) {
            attributeName = fullAttributeName.substring(windowIdStr.length());
        } else {
            return null;
        }
        String mappedPropertyName = (String)this.attributeToPropertyMappings.get((Object)attributeName);
        if (mappedPropertyName == null) {
            this.logger.warn("Attribute {} found that matches the portlet window ID but it is not listed in the propertyMappings or nonNamespacedProperties and will not be returned to the portlet", (Object)attributeName);
            return null;
        }
        return mappedPropertyName;
    }

    protected <P extends Populator<String, String>> void convertValue(String name, Object value, P propertiesPopulator) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                propertiesPopulator.put((Object)name, (Object)String.valueOf(obj));
            }
            return;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                propertiesPopulator.put((Object)name, (Object)String.valueOf(Array.get(value, i)));
            }
            return;
        }
        propertiesPopulator.put((Object)name, (Object)String.valueOf(value));
    }
}

