/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.driver.AdministrativeRequestListener;

public class AdministrativeRequestListenerController
implements AdministrativeRequestListener {
    public static final String DEFAULT_LISTENER_KEY_ATTRIBUTE = AdministrativeRequestListenerController.class.getName() + ".LISTENER_KEY";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String listenerKeyAttribute = DEFAULT_LISTENER_KEY_ATTRIBUTE;
    private Map<String, AdministrativeRequestListener> listeners = new HashMap();
    private boolean failOnKeyNotFound = false;
    private boolean failOnListenerNotFound = false;

    public boolean isFailOnKeyNotFound() {
        return this.failOnKeyNotFound;
    }

    public void setFailOnKeyNotFound(boolean failOnKeyNotFound) {
        this.failOnKeyNotFound = failOnKeyNotFound;
    }

    public boolean isFailOnListenerNotFound() {
        return this.failOnListenerNotFound;
    }

    public void setFailOnListenerNotFound(boolean failOnListenerNotFound) {
        this.failOnListenerNotFound = failOnListenerNotFound;
    }

    public String getListenerKeyAttribute() {
        return this.listenerKeyAttribute;
    }

    public void setListenerKeyAttribute(String listenerKeyAttribute) {
        this.listenerKeyAttribute = listenerKeyAttribute;
    }

    public Map<String, AdministrativeRequestListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, AdministrativeRequestListener> listeners) {
        this.listeners = listeners;
    }

    public void administer(PortletRequest request, PortletResponse response) {
        String listenerKey = (String)request.getAttribute(this.listenerKeyAttribute);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found key '" + listenerKey + "' from PortletRequest attribute '" + this.listenerKeyAttribute + "'"));
        }
        if (listenerKey == null) {
            if (this.failOnKeyNotFound) {
                this.logger.error((Object)("Failed to find PortletRequest attribute '" + this.listenerKeyAttribute + "'"));
                throw new IllegalArgumentException("Failed to find PortletRequest attribute '" + this.listenerKeyAttribute + "'");
            }
            this.logger.warn((Object)("Failed to find PortletRequest attribute '" + this.listenerKeyAttribute + "'"));
            return;
        }
        AdministrativeRequestListener administrativeRequestListener = (AdministrativeRequestListener)this.listeners.get(listenerKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found AdministrativeRequestListener '" + administrativeRequestListener + "' for key '" + listenerKey + "'"));
        }
        if (administrativeRequestListener == null) {
            if (this.failOnListenerNotFound) {
                this.logger.error((Object)("Failed to find AdministrativeRequestListener for key '" + listenerKey + "'"));
                throw new IllegalArgumentException("Failed to find AdministrativeRequestListener for key '" + listenerKey + "'");
            }
            this.logger.warn((Object)("Failed to find AdministrativeRequestListener for key '" + listenerKey + "'"));
            return;
        }
        administrativeRequestListener.administer(request, response);
    }
}

