/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.Validate;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.portlet.dao.IPortletTypeDao;
import org.jasig.portal.portlet.dao.jpa.PortletTypeImpl;
import org.jasig.portal.portlet.dao.jpa.PortletTypeImpl_;
import org.jasig.portal.portlet.om.IPortletType;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortletTypeDao
extends BasePortalJpaDao
implements IPortletTypeDao {
    private CriteriaQuery<PortletTypeImpl> findAllTypesQuery;

    public void afterPropertiesSet() throws Exception {
        this.findAllTypesQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BasePortalJpaDao.PortalTransactional
    public void deletePortletType(IPortletType type) {
        Validate.notNull((Object)type, (String)"definition can not be null");
        EntityManager entityManager = this.getEntityManager();
        IPortletType persistentChanneltype = entityManager.contains((Object)type) ? type : (IPortletType)entityManager.merge((Object)type);
        entityManager.remove((Object)persistentChanneltype);
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortletType createPortletType(String name, String cpdUri) {
        Validate.notEmpty((String)name, (String)"name can not be null");
        Validate.notEmpty((String)cpdUri, (String)"cpdUri can not be null");
        PortletTypeImpl channelType = new PortletTypeImpl(name, cpdUri);
        this.getEntityManager().persist((Object)channelType);
        return channelType;
    }

    public IPortletType getPortletType(int id) {
        return (IPortletType)this.getEntityManager().find(PortletTypeImpl.class, (Object)id);
    }

    @OpenEntityManager(unitName="PortalDb")
    public IPortletType getPortletType(String name) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(PortletTypeImpl.class);
        query.using((Attribute)PortletTypeImpl_.name, (Object)name);
        return (IPortletType)query.load();
    }

    public List<IPortletType> getPortletTypes() {
        TypedQuery query = this.createCachedQuery(this.findAllTypesQuery);
        List portletTypes = query.getResultList();
        return new ArrayList<IPortletType>(portletTypes);
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortletType updatePortletType(IPortletType type) {
        Validate.notNull((Object)type, (String)"type can not be null");
        this.getEntityManager().persist((Object)type);
        return type;
    }
}

