/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.jasig.portal.portlet.dao.jpa.PortletCookieImpl;
import org.jasig.portal.portlet.om.IPortalCookie;
import org.jasig.portal.portlet.om.IPortletCookie;
import org.joda.time.DateTime;

@Entity
@javax.persistence.Table(name="UP_PORTAL_COOKIES")
@SequenceGenerator(name="UP_PORTAL_COOKIES_GEN", sequenceName="UP_PORTAL_COOKIES_SEQ", allocationSize=100)
@TableGenerator(name="UP_PORTAL_COOKIES_GEN", pkColumnValue="UP_PORTAL_COOKIES", allocationSize=100)
@Table(appliesTo="UP_PORTAL_COOKIES", indexes={@Index(name="IDX_UP_PRTL_CK_EXP", columnNames={"EXPIRES"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PortalCookieImpl
implements IPortalCookie {
    @Id
    @GeneratedValue(generator="UP_PORTAL_COOKIES_GEN")
    @Column(name="PORTAL_COOKIE_ID")
    private final long internalPortalCookieId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @Column(name="CREATED", nullable=false, updatable=false)
    @Type(type="dateTime")
    private DateTime created;
    @Column(name="EXPIRES", nullable=false, updatable=true)
    @Type(type="dateTime")
    private DateTime expires;
    @NaturalId
    @Column(name="COOKIE_VALUE", length=100, nullable=false)
    private final String value;
    @OneToMany(targetEntity=PortletCookieImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="PORTAL_COOKIE_ID")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Set<IPortletCookie> portletCookies;

    private PortalCookieImpl() {
        this.internalPortalCookieId = -1L;
        this.entityVersion = -1L;
        this.created = DateTime.now();
        this.expires = null;
        this.value = null;
        this.portletCookies = new HashSet();
    }

    PortalCookieImpl(String value, DateTime expiration) {
        this.internalPortalCookieId = -1L;
        this.entityVersion = -1L;
        this.value = value;
        this.created = DateTime.now();
        this.expires = expiration;
        this.portletCookies = new HashSet();
    }

    public long getInternalPortalCookieId() {
        return this.internalPortalCookieId;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public String getValue() {
        return this.value;
    }

    public Set<IPortletCookie> getPortletCookies() {
        return this.portletCookies;
    }

    public void setExpires(DateTime expires) {
        this.expires = expires;
    }

    public String toString() {
        return "PortalCookieImpl [internalPortalCookieId=" + this.internalPortalCookieId + ", entityVersion=" + this.entityVersion + ", created=" + this.created + ", expires=" + this.expires + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortalCookieImpl other = (PortalCookieImpl)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

