/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionIdImpl;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionParameterImpl;
import org.jasig.portal.portlet.dao.jpa.PortletDescriptorKeyImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityImpl;
import org.jasig.portal.portlet.dao.jpa.PortletLocalizationData;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl;
import org.jasig.portal.portlet.dao.jpa.PortletTypeImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletDescriptorKey;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.om.PortletLifecycleState;

@Entity
@Table(name="UP_PORTLET_DEF")
@SequenceGenerator(name="UP_PORTLET_DEF_GEN", sequenceName="UP_PORTLET_DEF_SEQ", allocationSize=5)
@TableGenerator(name="UP_PORTLET_DEF_GEN", pkColumnValue="UP_PORTLET_DEF", allocationSize=5)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PortletDefinitionImpl
implements IPortletDefinition {
    @Id
    @GeneratedValue(generator="UP_PORTLET_DEF_GEN")
    @Column(name="PORTLET_DEF_ID")
    private final long internalPortletDefinitionId;
    @Transient
    private IPortletDefinitionId portletDefinitionId = null;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @OneToMany(mappedBy="portletDefinition", targetEntity=PortletEntityImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Set<IPortletEntity> portletEntities = null;
    @OneToOne(targetEntity=PortletPreferencesImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="PORTLET_PREFS_ID", nullable=false)
    @Fetch(value=FetchMode.JOIN)
    private final PortletPreferencesImpl portletPreferences;
    @Column(name="PORTLET_NAME", length=128, nullable=false, unique=true)
    private String name;
    @NaturalId(mutable=true)
    @Column(name="PORTLET_FNAME", length=255, nullable=false)
    @Type(type="fname")
    private String fname;
    @Column(name="PORTLET_TITLE", length=128, nullable=false)
    @Index(name="IDX_PORTLET_DEF__TITLE")
    private String title;
    @ManyToOne(targetEntity=PortletTypeImpl.class, optional=false)
    @JoinColumn(name="PORTLET_TYPE_ID", nullable=false)
    private IPortletType portletType;
    @Column(name="PORTLET_DESC", length=255)
    private String description;
    @Column(name="PORTLET_TIMEOUT", nullable=false)
    private int timeout = 20000;
    @Column(name="ACTION_TIMEOUT")
    private Integer actionTimeout = null;
    @Column(name="EVENT_TIMEOUT")
    private Integer eventTimeout = null;
    @Column(name="RENDER_TIMEOUT")
    private Integer renderTimeout = null;
    @Column(name="RESOURCE_TIMEOUT")
    private Integer resourceTimeout = null;
    @Column(name="PORTLET_PUBL_ID")
    private int publisherId = -1;
    @Column(name="PORTLET_APVL_ID")
    private int approverId = -1;
    @Column(name="PORTLET_EXP_ID")
    private int expirerId = -1;
    @Column(name="PORTLET_PUBL_DT")
    private Date publishDate = null;
    @Column(name="PORTLET_APVL_DT")
    private Date approvalDate = null;
    @Column(name="PORTLET_EXP_DT")
    private Date expirationDate = null;
    @OneToMany(targetEntity=PortletDefinitionParameterImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="PORLTET_DEF_ID", nullable=false)
    @MapKey(name="name")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<String, IPortletDefinitionParameter> parameters = new LinkedHashMap();
    @ElementCollection(fetch=FetchType.EAGER, targetClass=PortletLocalizationData.class)
    @JoinTable(name="UP_PORTLET_DEF_MDATA", joinColumns={@JoinColumn(name="PORTLET_ID")})
    @MapKeyColumn(name="LOCALE", length=64, nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Map<String, PortletLocalizationData> localizations = new LinkedHashMap();
    @Embedded
    private PortletDescriptorKeyImpl portletDescriptorKey;

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void init() {
        if (this.internalPortletDefinitionId != -1L && (this.portletDefinitionId == null || this.portletDefinitionId.getLongId() != this.internalPortletDefinitionId)) {
            this.portletDefinitionId = PortletDefinitionIdImpl.create((long)this.internalPortletDefinitionId);
        }
    }

    private PortletDefinitionImpl() {
        this.internalPortletDefinitionId = -1L;
        this.entityVersion = -1L;
        this.portletPreferences = null;
    }

    public PortletDefinitionImpl(IPortletType portletType, String fname, String name, String title, String applicationId, String portletName, boolean isFramework) {
        Validate.notNull((Object)portletType);
        Validate.notNull((Object)name);
        Validate.notNull((Object)fname);
        Validate.notNull((Object)title);
        if (!isFramework) {
            Validate.notNull((Object)applicationId);
        }
        Validate.notNull((Object)portletName);
        this.internalPortletDefinitionId = -1L;
        this.entityVersion = -1L;
        this.portletPreferences = new PortletPreferencesImpl();
        this.portletType = portletType;
        this.name = name;
        this.fname = fname;
        this.title = title;
        this.portletDescriptorKey = new PortletDescriptorKeyImpl();
        this.portletDescriptorKey.setWebAppName(applicationId);
        this.portletDescriptorKey.setPortletName(portletName);
        this.portletDescriptorKey.setFrameworkPortlet(isFramework);
    }

    public String getDataId() {
        return this.getFName();
    }

    public String getDataTitle() {
        return this.getName();
    }

    public String getDataDescription() {
        return this.getDescription();
    }

    public IPortletDefinitionId getPortletDefinitionId() {
        this.init();
        return this.portletDefinitionId;
    }

    public List<IPortletPreference> getPortletPreferences() {
        return this.portletPreferences.getPortletPreferences();
    }

    public boolean setPortletPreferences(List<IPortletPreference> portletPreferences) {
        return this.portletPreferences.setPortletPreferences(portletPreferences);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFName() {
        return this.fname;
    }

    public void setFName(String fname) {
        this.fname = fname;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Integer getActionTimeout() {
        return this.actionTimeout;
    }

    public void setActionTimeout(Integer actionTimeout) {
        this.actionTimeout = actionTimeout;
    }

    public Integer getEventTimeout() {
        return this.eventTimeout;
    }

    public void setEventTimeout(Integer eventTimeout) {
        this.eventTimeout = eventTimeout;
    }

    public Integer getRenderTimeout() {
        return this.renderTimeout;
    }

    public void setRenderTimeout(Integer renderTimeout) {
        this.renderTimeout = renderTimeout;
    }

    public Integer getResourceTimeout() {
        return this.resourceTimeout;
    }

    public void setResourceTimeout(Integer resourceTimeout) {
        this.resourceTimeout = resourceTimeout;
    }

    public int getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(int publisherId) {
        this.publisherId = publisherId;
    }

    public int getApproverId() {
        return this.approverId;
    }

    public void setApproverId(int approverId) {
        this.approverId = approverId;
    }

    public int getExpirerId() {
        return this.expirerId;
    }

    public void setExpirerId(int expirerId) {
        this.expirerId = expirerId;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public IPortletType getType() {
        return this.portletType;
    }

    public String getName(String locale) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData != null && localeData.getName() != null) {
            return localeData.getName();
        }
        return this.name;
    }

    public String getDescription(String locale) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData != null && localeData.getDescription() != null) {
            return localeData.getDescription();
        }
        return this.description;
    }

    public String getTitle(String locale) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData != null && localeData.getTitle() != null) {
            return localeData.getTitle();
        }
        return this.title;
    }

    public void setType(IPortletType portletType) {
        this.portletType = portletType;
    }

    public IPortletDescriptorKey getPortletDescriptorKey() {
        return this.portletDescriptorKey;
    }

    public void addLocalizedDescription(String locale, String chanDesc) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData == null) {
            localeData = new PortletLocalizationData();
        }
        localeData.setDescription(chanDesc);
        this.localizations.put(locale, localeData);
    }

    public void addLocalizedName(String locale, String chanName) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData == null) {
            localeData = new PortletLocalizationData();
        }
        localeData.setName(chanName);
        this.localizations.put(locale, localeData);
    }

    public void addLocalizedTitle(String locale, String chanTitle) {
        PortletLocalizationData localeData = (PortletLocalizationData)this.localizations.get(locale);
        if (localeData == null) {
            localeData = new PortletLocalizationData();
        }
        localeData.setTitle(chanTitle);
        this.localizations.put(locale, localeData);
    }

    public Set<IPortletDefinitionParameter> getParameters() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.parameters.values()));
    }

    public void setParameters(Set<IPortletDefinitionParameter> newParameters) {
        if (this.parameters == newParameters) {
            return;
        }
        if (newParameters == null) {
            this.parameters = new LinkedHashMap();
        } else if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
            for (IPortletDefinitionParameter parameter : newParameters) {
                this.parameters.put(parameter.getName(), parameter);
            }
        } else {
            LinkedHashMap oldPreferences = new LinkedHashMap(this.parameters);
            for (IPortletDefinitionParameter parameter : newParameters) {
                String name = parameter.getName();
                IPortletDefinitionParameter existingParameter = (IPortletDefinitionParameter)oldPreferences.remove(name);
                if (existingParameter == null) {
                    this.parameters.put(name, parameter);
                    continue;
                }
                existingParameter.setDescription(parameter.getDescription());
                existingParameter.setValue(parameter.getValue());
                this.parameters.put(name, existingParameter);
            }
            this.parameters.keySet().removeAll(oldPreferences.keySet());
        }
    }

    public IPortletDefinitionParameter getParameter(String key) {
        return (IPortletDefinitionParameter)this.parameters.get(key);
    }

    public Map<String, IPortletDefinitionParameter> getParametersAsUnmodifiableMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void removeParameter(IPortletDefinitionParameter parameter) {
        this.parameters.remove(parameter.getName());
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void addParameter(IPortletDefinitionParameter parameter) {
        String name = parameter.getName();
        IPortletDefinitionParameter existingParameter = (IPortletDefinitionParameter)this.parameters.get(name);
        if (existingParameter != null) {
            existingParameter.setDescription(parameter.getDescription());
            existingParameter.setValue(parameter.getValue());
        } else {
            this.parameters.put(name, parameter);
        }
    }

    public void addParameter(String name, String value) {
        IPortletDefinitionParameter existingParameter = (IPortletDefinitionParameter)this.parameters.get(name);
        if (existingParameter != null) {
            existingParameter.setValue(value);
        } else {
            this.parameters.put(name, new PortletDefinitionParameterImpl(name, value));
        }
    }

    public EntityIdentifier getEntityIdentifier() {
        return new EntityIdentifier(String.valueOf(this.portletDefinitionId.getStringId()), IPortletDefinition.class);
    }

    public PortletLifecycleState getLifecycleState() {
        Date now = new Date();
        if (this.expirationDate != null && this.expirationDate.before(now)) {
            return PortletLifecycleState.EXPIRED;
        }
        if (this.publishDate != null && this.publishDate.before(now)) {
            return PortletLifecycleState.PUBLISHED;
        }
        if (this.approvalDate != null && this.approvalDate.before(now)) {
            return PortletLifecycleState.APPROVED;
        }
        return PortletLifecycleState.CREATED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fname == null ? 0 : this.fname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IPortletDefinition.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IPortletDefinition other = (IPortletDefinition)obj;
        return !(this.fname == null ? other.getFName() != null : !this.fname.equals(other.getFName()));
    }

    public String toString() {
        return "PortletDefinition [portletDefinitionId=" + this.portletDefinitionId + ", " + "fname=" + this.fname + ", " + "portletDescriptorKey=" + this.portletDescriptorKey + ", " + "portletType=" + this.portletType + "]";
    }
}

