/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Deque;
import java.util.LinkedList;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.Ordered;

public class ThreadContextClassLoaderAspect
implements Ordered {
    private static final ClassLoader PORTAL_CLASS_LOADER = ThreadContextClassLoaderAspect.class.getClassLoader();
    private static final ThreadLocal<Deque<ClassLoader>> PREVIOUS_CLASS_LOADER = new ThreadLocal();

    public static ClassLoader getPreviousClassLoader() {
        Deque deque = (Deque)PREVIOUS_CLASS_LOADER.get();
        if (deque == null) {
            return null;
        }
        return (ClassLoader)deque.peekFirst();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doThreadContextClassLoaderUpdate(ProceedingJoinPoint pjp) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        LinkedList<ClassLoader> deque = (LinkedList<ClassLoader>)PREVIOUS_CLASS_LOADER.get();
        if (deque == null) {
            deque = new LinkedList<ClassLoader>();
            PREVIOUS_CLASS_LOADER.set(deque);
        }
        deque.push(previousClassLoader);
        try {
            currentThread.setContextClassLoader(PORTAL_CLASS_LOADER);
            Object object = pjp.proceed();
            return object;
        }
        finally {
            currentThread.setContextClassLoader(previousClassLoader);
            deque.removeFirst();
            if (deque.isEmpty()) {
                PREVIOUS_CLASS_LOADER.remove();
            }
        }
    }
}

