/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.api.portlet.DelegateState;
import org.jasig.portal.api.portlet.DelegationActionResponse;
import org.jasig.portal.api.portlet.DelegationRequest;
import org.jasig.portal.api.portlet.DelegationResponse;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.delegation.RenderResponsePortletOutputHandler;
import org.jasig.portal.portlet.delegation.ResourceResponsePortletOutputHandler;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalActionUrlBuilder;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;

public class PortletDelegationDispatcherImpl
implements PortletDelegationDispatcher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IPortletWindow portletWindow;
    private final int userId;
    private final IPortalRequestUtils portalRequestUtils;
    private final IPersonManager personManager;
    private final IPortletRenderer portletRenderer;
    private final IPortalUrlProvider portalUrlProvider;
    private final IPortletDelegationManager portletDelegationManager;

    public PortletDelegationDispatcherImpl(IPortletWindow portletWindow, int userId, IPortalRequestUtils portalRequestUtils, IPersonManager personManager, IPortletRenderer portletRenderer, IPortalUrlProvider portalUrlProvider, IPortletDelegationManager portletDelegationManager) {
        Validate.notNull((Object)portletWindow, (String)"portletWindow can not be null");
        Validate.notNull((Object)portalRequestUtils, (String)"portalRequestUtils can not be null");
        Validate.notNull((Object)personManager, (String)"personManager can not be null");
        Validate.notNull((Object)portletRenderer, (String)"portletRenderer can not be null");
        Validate.notNull((Object)portalUrlProvider, (String)"portalUrlProvider can not be null");
        Validate.notNull((Object)portletDelegationManager, (String)"portletDelegationManager can not be null");
        this.portletWindow = portletWindow;
        this.userId = userId;
        this.portalRequestUtils = portalRequestUtils;
        this.personManager = personManager;
        this.portletRenderer = portletRenderer;
        this.portalUrlProvider = portalUrlProvider;
        this.portletDelegationManager = portletDelegationManager;
    }

    public DelegationActionResponse doAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        return this.doAction(actionRequest, actionResponse, null);
    }

    public DelegationActionResponse doAction(ActionRequest actionRequest, ActionResponse actionResponse, DelegationRequest delegationRequest) throws IOException {
        HttpServletRequest request = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)actionRequest);
        HttpServletResponse response = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)actionRequest);
        IPerson person = this.personManager.getPerson(request);
        if (this.userId != person.getID()) {
            throw new IllegalStateException("This dispatcher was created for userId " + this.userId + " but is being executed for userId " + person.getID());
        }
        this.setupDelegateRequestInfo(request, delegationRequest);
        IPortletWindowId portletWindowId = this.portletWindow.getPortletWindowId();
        try {
            this.portletRenderer.doAction(portletWindowId, request, response);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to execute action on delegate", (Throwable)e);
            throw e;
        }
        IPortalActionUrlBuilder portalActionUrlBuilder = this.portalUrlProvider.getPortalActionUrlBuilder(request);
        String redirectLocation = portalActionUrlBuilder.getRedirectLocation();
        if (redirectLocation != null) {
            String renderUrlParamName = portalActionUrlBuilder.getRenderUrlParamName();
            portalActionUrlBuilder.setRedirectLocation(null, null);
            return new DelegationActionResponse(this.getDelegateState(), redirectLocation, renderUrlParamName);
        }
        IPortletUrlBuilder portletUrlBuilder = portalActionUrlBuilder.getPortletUrlBuilder(portletWindowId);
        WindowState windowState = portletUrlBuilder.getWindowState();
        PortletMode portletMode = portletUrlBuilder.getPortletMode();
        Map parameters = portletUrlBuilder.getParameters();
        return new DelegationActionResponse(this.getDelegateState(), portletMode, windowState, parameters);
    }

    public DelegationResponse doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        return this.doServeResource(resourceRequest, resourceResponse, null, (PortletResourceOutputHandler)new ResourceResponsePortletOutputHandler(resourceResponse));
    }

    public DelegationResponse doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, DelegationRequest delegationRequest) throws IOException {
        return this.doServeResource(resourceRequest, resourceResponse, delegationRequest, (PortletResourceOutputHandler)new ResourceResponsePortletOutputHandler(resourceResponse));
    }

    public DelegationResponse doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, DelegationRequest delegationRequest, PortletResourceOutputHandler portletOutputHandler) throws IOException {
        HttpServletRequest request = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)resourceRequest);
        HttpServletResponse response = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)resourceRequest);
        IPerson person = this.personManager.getPerson(request);
        if (this.userId != person.getID()) {
            throw new IllegalStateException("This dispatcher was created for userId " + this.userId + " but is being executed for userId " + person.getID());
        }
        this.setupDelegateRequestInfo(request, delegationRequest);
        try {
            this.portletRenderer.doServeResource(this.portletWindow.getPortletWindowId(), request, response, portletOutputHandler);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to render delegate", (Throwable)e);
            throw e;
        }
        return new DelegationResponse(this.getDelegateState());
    }

    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        return this.doRender(renderRequest, renderResponse, null, (PortletOutputHandler)new RenderResponsePortletOutputHandler(renderResponse));
    }

    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, PortletOutputHandler portletOutputHandler) throws IOException {
        return this.doRender(renderRequest, renderResponse, null, portletOutputHandler);
    }

    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, DelegationRequest delegationRequest) throws IOException {
        return this.doRender(renderRequest, renderResponse, delegationRequest, (PortletOutputHandler)new RenderResponsePortletOutputHandler(renderResponse));
    }

    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, DelegationRequest delegationRequest, PortletOutputHandler portletOutputHandler) throws IOException {
        HttpServletRequest request = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)renderRequest);
        HttpServletResponse response = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)renderRequest);
        IPerson person = this.personManager.getPerson(request);
        if (this.userId != person.getID()) {
            throw new IllegalStateException("This dispatcher was created for userId " + this.userId + " but is being executed for userId " + person.getID());
        }
        this.setupDelegateRequestInfo(request, delegationRequest);
        try {
            this.portletRenderer.doRenderMarkup(this.portletWindow.getPortletWindowId(), request, response, portletOutputHandler);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to render delegate", (Throwable)e);
            throw e;
        }
        finally {
            portletOutputHandler.flushBuffer();
        }
        return new DelegationResponse(this.getDelegateState());
    }

    public DelegateState getDelegateState() {
        return new DelegateState(this.portletWindow.getPortletMode(), this.portletWindow.getWindowState());
    }

    public IPortletWindowId getPortletWindowId() {
        return this.portletWindow.getPortletWindowId();
    }

    protected void setupDelegateRequestInfo(HttpServletRequest request, DelegationRequest delegationRequest) {
        if (delegationRequest == null) {
            return;
        }
        DelegateState delegateState = delegationRequest.getDelegateState();
        if (delegateState != null) {
            WindowState windowState;
            PortletMode portletMode = delegateState.getPortletMode();
            if (portletMode != null) {
                this.portletWindow.setPortletMode(portletMode);
            }
            if ((windowState = delegateState.getWindowState()) != null) {
                this.portletWindow.setWindowState(windowState);
            }
        }
        IPortletWindowId portletWindowId = this.portletWindow.getPortletWindowId();
        this.portletDelegationManager.setDelegationRequest(request, portletWindowId, delegationRequest);
    }
}

