/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.api.portlet.DelegationRequest;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletDelegationManagerImpl
implements IPortletDelegationManager {
    private static final String DELEGATION_REQUEST_MAP_ATTR = PortletDelegationManagerImpl.class.getName() + ".DELEGATION_REQUEST_MAP";
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public void setDelegationRequest(HttpServletRequest request, IPortletWindowId delegatePortletWindowId, DelegationRequest delegationRequest) {
        ConcurrentMap delegationRequestMap = this.getDelegationRequestMap(request);
        delegationRequestMap.put(delegatePortletWindowId, delegationRequest);
    }

    public DelegationRequest getDelegationRequest(HttpServletRequest request, IPortletWindowId delegatePortletWindowId) {
        ConcurrentMap delegationRequestMap = this.getDelegationRequestMap(request);
        return (DelegationRequest)delegationRequestMap.get(delegatePortletWindowId);
    }

    protected ConcurrentMap<IPortletWindowId, DelegationRequest> getDelegationRequestMap(HttpServletRequest request) {
        request = this.portalRequestUtils.getOriginalPortletOrPortalRequest(request);
        ConcurrentMap delegationRequestMap = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)DELEGATION_REQUEST_MAP_ATTR);
        return delegationRequestMap;
    }
}

