/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortalDriverContainerServices;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.utils.Tuple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

@Service(value="portletDefinitionRegistry")
public class PortletDefinitionRegistryImpl
implements IPortletDefinitionRegistry,
ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionDao portletDefinitionDao;
    private PortalDriverContainerServices portalDriverContainerServices;
    private ServletContext servletContext;

    public IPortletDefinitionDao getPortletDefinitionDao() {
        return this.portletDefinitionDao;
    }

    @Autowired
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    public PortalDriverContainerServices getPortalDriverContainerServices() {
        return this.portalDriverContainerServices;
    }

    @Autowired
    public void setPortalDriverContainerServices(PortalDriverContainerServices portalDriverContainerServices) {
        this.portalDriverContainerServices = portalDriverContainerServices;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public IPortletDefinition getPortletDefinition(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        return this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
    }

    public IPortletDefinition getPortletDefinition(String portletDefinitionIdString) {
        Validate.notNull((Object)portletDefinitionIdString, (String)"portletDefinitionId can not be null");
        return this.portletDefinitionDao.getPortletDefinition(portletDefinitionIdString);
    }

    public IPortletDefinition getPortletDefinitionByFname(String fname) {
        Validate.notNull((Object)fname, (String)"portletFname can not be null");
        return this.portletDefinitionDao.getPortletDefinitionByFname(fname);
    }

    @RequestCache
    public IPortletDefinition getPortletDefinitionByName(String name) {
        Validate.notNull((Object)name, (String)"portletFname can not be null");
        return this.portletDefinitionDao.getPortletDefinitionByName(name);
    }

    public List<IPortletDefinition> searchForPortlets(String term, boolean allowPartial) {
        return this.portletDefinitionDao.searchForPortlets(term, allowPartial);
    }

    public List<IPortletDefinition> getAllPortletDefinitions() {
        return this.portletDefinitionDao.getPortletDefinitions();
    }

    public IPortletDefinition createPortletDefinition(IPortletType portletType, String fname, String name, String title, String applicationId, String portletName, boolean isFramework) {
        return this.portletDefinitionDao.createPortletDefinition(portletType, fname, name, title, applicationId, portletName, isFramework);
    }

    public IPortletDefinition updatePortletDefinition(IPortletDefinition portletDefinition) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        return this.portletDefinitionDao.updatePortletDefinition(portletDefinition);
    }

    public void deletePortletDefinition(IPortletDefinition portletDefinition) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        this.portletDefinitionDao.deletePortletDefinition(portletDefinition);
    }

    public PortletApplicationDefinition getParentPortletApplicationDescriptor(IPortletDefinitionId portletDefinitionId) {
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            return null;
        }
        Tuple portletDescriptorKeys = this.getPortletDescriptorKeys(portletDefinition);
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        try {
            return portletRegistryService.getPortletApplication((String)portletDescriptorKeys.first);
        }
        catch (PortletContainerException e) {
            this.logger.warn((Object)("No portlet application descriptor could be found likely not deplotyed. For portlet definition: " + portletDefinition), (Throwable)e);
            return null;
        }
    }

    public PortletDefinition getParentPortletDescriptor(IPortletDefinitionId portletDefinitionId) {
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            return null;
        }
        Tuple portletDescriptorKeys = this.getPortletDescriptorKeys(portletDefinition);
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        try {
            return portletRegistryService.getPortlet((String)portletDescriptorKeys.first, (String)portletDescriptorKeys.second);
        }
        catch (PortletContainerException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)("No portlet descriptor could be found for the portlet definition, null will be returned: " + portletDefinition), (Throwable)e);
            } else {
                this.logger.warn((Object)("No portlet descriptor could be found for the portlet definition, null will be returned: " + portletDefinition + " Enable DEBUG for stack trace."));
            }
            return null;
        }
    }

    public Tuple<String, String> getPortletDescriptorKeys(IPortletDefinition portletDefinition) {
        String portletApplicationId = portletDefinition.getPortletDescriptorKey().isFrameworkPortlet() ? this.servletContext.getContextPath() : portletDefinition.getPortletDescriptorKey().getWebAppName();
        String portletName = portletDefinition.getPortletDescriptorKey().getPortletName();
        return new Tuple((Object)portletApplicationId, (Object)portletName);
    }
}

