/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindowDescriptor;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.utils.threading.NoopLock;

class PortletWindowCache<T extends IPortletWindowDescriptor>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock writeLock;
    private final Lock readLock;
    private final Map<IPortletEntityId, Set<T>> windowSetByEntityId = new HashMap();
    private final Map<IPortletWindowId, T> windowsById = new HashMap();

    public PortletWindowCache() {
        this(true);
    }

    public PortletWindowCache(boolean threadSafe) {
        if (threadSafe) {
            ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
            this.writeLock = cacheLock.writeLock();
            this.readLock = cacheLock.readLock();
        } else {
            this.writeLock = NoopLock.INSTANCE;
            this.readLock = NoopLock.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T storeIfAbsentWindow(IPortletWindowId portletWindowId, Function<IPortletWindowId, T> windowCreator) {
        IPortletWindowDescriptor existingWindow = this.getWindow(portletWindowId);
        if (existingWindow != null) {
            return (T)existingWindow;
        }
        this.writeLock.lock();
        try {
            existingWindow = (IPortletWindowDescriptor)this.windowsById.get(portletWindowId);
            if (existingWindow != null) {
                IPortletWindowDescriptor iPortletWindowDescriptor = existingWindow;
                return (T)iPortletWindowDescriptor;
            }
            IPortletWindowDescriptor window = (IPortletWindowDescriptor)windowCreator.apply((Object)portletWindowId);
            this.storeWindow(window);
            IPortletWindowDescriptor iPortletWindowDescriptor = window;
            return (T)iPortletWindowDescriptor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T storeIfAbsentWindow(T window) {
        IPortletWindowId portletWindowId = window.getPortletWindowId();
        IPortletWindowDescriptor existingWindow = this.getWindow(portletWindowId);
        if (existingWindow != null) {
            return (T)existingWindow;
        }
        this.writeLock.lock();
        try {
            existingWindow = (IPortletWindowDescriptor)this.windowsById.get(portletWindowId);
            if (existingWindow != null) {
                IPortletWindowDescriptor iPortletWindowDescriptor = existingWindow;
                return (T)iPortletWindowDescriptor;
            }
            this.storeWindow(window);
        }
        finally {
            this.writeLock.unlock();
        }
        return window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWindow(T window) {
        this.writeLock.lock();
        try {
            IPortletEntityId portletEntityId = window.getPortletEntityId();
            Set windowSet = this.getWindowSet(portletEntityId, true);
            windowSet.add(window);
            IPortletWindowId portletWindowId = window.getPortletWindowId();
            this.windowsById.put(portletWindowId, window);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsWindow(IPortletWindowId portletWindowId) {
        if (this.windowSetByEntityId.isEmpty()) {
            return false;
        }
        this.readLock.lock();
        try {
            boolean bl = this.windowsById.containsKey(portletWindowId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getWindows(IPortletEntityId portletEntityId) {
        if (this.windowSetByEntityId.isEmpty()) {
            return null;
        }
        this.readLock.lock();
        try {
            Set windowSet = this.getWindowSet(portletEntityId, false);
            if (windowSet == null) {
                Set set = Collections.emptySet();
                return set;
            }
            Set set = Collections.unmodifiableSet(windowSet);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getWindow(IPortletWindowId portletWindowId) {
        if (this.windowsById.isEmpty()) {
            return null;
        }
        this.readLock.lock();
        try {
            IPortletWindowDescriptor iPortletWindowDescriptor = (IPortletWindowDescriptor)this.windowsById.get(portletWindowId);
            return (T)iPortletWindowDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(IPortletWindowId portletWindowId) {
        this.writeLock.lock();
        try {
            IPortletEntityId portletEntityId;
            Set windowSet;
            IPortletWindowDescriptor window = (IPortletWindowDescriptor)this.windowsById.remove(portletWindowId);
            if (window != null && (windowSet = this.getWindowSet(portletEntityId = window.getPortletEntityId(), false)) != null) {
                windowSet.remove(window);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected Set<T> getWindowSet(IPortletEntityId portletEntityId, boolean create) {
        LinkedHashSet windowSet = (LinkedHashSet)this.windowSetByEntityId.get(portletEntityId);
        if (windowSet == null && create) {
            windowSet = new LinkedHashSet();
            this.windowSetByEntityId.put(portletEntityId, windowSet);
        }
        return windowSet;
    }
}

