/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.Validate;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.PortletWindowID;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.PortletWindowData;

class PortletWindowImpl
implements IPortletWindow,
PortletWindow {
    private static final long serialVersionUID = 1L;
    private final PortletDefinition portletDefinition;
    private final IPortletEntity portletEntity;
    private final PortletWindowData portletWindowData;
    private Map<String, String[]> renderParameters = null;
    private Map<String, String[]> publicRenderParameters = null;
    private PortletMode portletMode = null;
    private WindowState windowState = null;
    private Integer expirationCache = null;

    public PortletWindowImpl(PortletDefinition portletDefinition, IPortletEntity portletEntity, PortletWindowData portletWindowData) {
        Validate.notNull((Object)portletDefinition);
        Validate.notNull((Object)portletEntity);
        Validate.notNull((Object)portletWindowData);
        this.portletDefinition = portletDefinition;
        this.portletEntity = portletEntity;
        this.portletWindowData = portletWindowData;
    }

    public PortletWindowID getId() {
        return this.portletWindowData.getPortletWindowId();
    }

    public IPortletEntityId getPortletEntityId() {
        return this.portletEntity.getPortletEntityId();
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public IPortletWindowId getPortletWindowId() {
        return this.portletWindowData.getPortletWindowId();
    }

    public IPortletEntity getPortletEntity() {
        return this.portletEntity;
    }

    public WindowState getWindowState() {
        if (this.windowState != null) {
            return this.windowState;
        }
        return this.portletWindowData.getWindowState();
    }

    public void setWindowState(WindowState state) {
        Validate.notNull((Object)state, (String)"state can not be null");
        this.windowState = state;
        this.portletWindowData.setWindowState(state);
    }

    public PortletMode getPortletMode() {
        if (this.portletMode != null) {
            return this.portletMode;
        }
        return this.portletWindowData.getPortletMode();
    }

    public void setPortletMode(PortletMode mode) {
        Validate.notNull((Object)mode, (String)"mode can not be null");
        this.portletMode = mode;
        this.portletWindowData.setPortletMode(mode);
    }

    public void setRenderParameters(Map<String, String[]> requestParameters) {
        this.renderParameters = requestParameters = Collections.unmodifiableMap(requestParameters);
        this.portletWindowData.setRenderParameters(requestParameters);
    }

    public Map<String, String[]> getRenderParameters() {
        if (this.renderParameters != null) {
            return this.renderParameters;
        }
        return this.portletWindowData.getRenderParameters();
    }

    public Map<String, String[]> getPublicRenderParameters() {
        if (this.publicRenderParameters != null) {
            return this.publicRenderParameters;
        }
        return this.portletWindowData.getPublicRenderParameters();
    }

    public void setPublicRenderParameters(Map<String, String[]> requestParameters) {
        this.publicRenderParameters = requestParameters = Collections.unmodifiableMap(requestParameters);
        this.portletWindowData.setPublicRenderParameters(requestParameters);
    }

    public void setExpirationCache(Integer expirationCache) {
        this.expirationCache = expirationCache;
        this.portletWindowData.setExpirationCache(expirationCache);
    }

    public Integer getExpirationCache() {
        if (this.expirationCache != null) {
            return this.expirationCache;
        }
        return this.portletWindowData.getExpirationCache();
    }

    public PortletWindow getPlutoPortletWindow() {
        return this;
    }

    public IPortletWindowId getDelegationParentId() {
        return this.portletWindowData.getDelegationParentId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portletEntity == null ? 0 : this.portletEntity.hashCode());
        result = 31 * result + (this.portletWindowData.getPortletWindowId() == null ? 0 : this.portletWindowData.getPortletWindowId().hashCode());
        result = 31 * result + (this.portletWindowData.getDelegationParentId() == null ? 0 : this.portletWindowData.getDelegationParentId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IPortletWindow.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IPortletWindow other = (IPortletWindow)obj;
        if (this.portletEntity == null ? other.getPortletEntity() != null : !this.portletEntity.equals((Object)other.getPortletEntity())) {
            return false;
        }
        if (this.portletWindowData.getDelegationParentId() == null ? other.getDelegationParentId() != null : !this.portletWindowData.getDelegationParentId().equals(other.getDelegationParentId())) {
            return false;
        }
        return !(this.portletWindowData.getPortletWindowId() == null ? other.getPortletWindowId() != null : !this.portletWindowData.getPortletWindowId().equals(other.getPortletWindowId()));
    }

    public String toString() {
        return "PortletWindow [portletWindowId=" + this.portletWindowData.getPortletWindowId() + ", " + "delegationParentId=" + this.portletWindowData.getDelegationParentId() + ", " + "portletMode=" + this.portletWindowData.getPortletMode() + ", " + "windowState=" + this.portletWindowData.getWindowState() + ", " + "expirationCache=" + this.portletWindowData.getExpirationCache() + ", " + "renderParameters=" + this.portletWindowData.getRenderParameters() + ", " + "publicRenderParameters=" + this.portletWindowData.getPublicRenderParameters() + ", " + "portletEntity=" + this.portletEntity + "]";
    }
}

