/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;

public class LazyServletOutputStream
extends ServletOutputStream {
    private final Callable<ServletOutputStream> servletOutputStreamCreator;
    private ServletOutputStream servletOutputStream;

    public LazyServletOutputStream(Callable<ServletOutputStream> servletOutputStreamCreator) {
        this.servletOutputStreamCreator = servletOutputStreamCreator;
    }

    private ServletOutputStream getServletOutputStream() {
        if (this.servletOutputStream == null) {
            try {
                this.servletOutputStream = (ServletOutputStream)this.servletOutputStreamCreator.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to lazily create ServletOutputStream", e);
            }
        }
        return this.servletOutputStream;
    }

    public void write(int b) throws IOException {
        this.getServletOutputStream().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.getServletOutputStream().write(b);
    }

    public void print(String s) throws IOException {
        this.getServletOutputStream().print(s);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.getServletOutputStream().write(b, off, len);
    }

    public void print(boolean b) throws IOException {
        this.getServletOutputStream().print(b);
    }

    public void print(char c) throws IOException {
        this.getServletOutputStream().print(c);
    }

    public void print(int i) throws IOException {
        this.getServletOutputStream().print(i);
    }

    public void flush() throws IOException {
        this.getServletOutputStream().flush();
    }

    public void print(long l) throws IOException {
        this.getServletOutputStream().print(l);
    }

    public void print(float f) throws IOException {
        this.getServletOutputStream().print(f);
    }

    public void close() throws IOException {
        this.getServletOutputStream().close();
    }

    public void print(double d) throws IOException {
        this.getServletOutputStream().print(d);
    }

    public void println() throws IOException {
        this.getServletOutputStream().println();
    }

    public void println(String s) throws IOException {
        this.getServletOutputStream().println(s);
    }

    public void println(boolean b) throws IOException {
        this.getServletOutputStream().println(b);
    }

    public void println(char c) throws IOException {
        this.getServletOutputStream().println(c);
    }

    public void println(int i) throws IOException {
        this.getServletOutputStream().println(i);
    }

    public void println(long l) throws IOException {
        this.getServletOutputStream().println(l);
    }

    public void println(float f) throws IOException {
        this.getServletOutputStream().println(f);
    }

    public void println(double d) throws IOException {
        this.getServletOutputStream().println(d);
    }
}

