/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.portlet.Event;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.events.IPortletExecutionEventFactory;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletDescriptorKey;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletEventCoordinationService;
import org.jasig.portal.portlet.rendering.IPortletExecutionManager;
import org.jasig.portal.portlet.rendering.PortletEventQueue;
import org.jasig.portal.portlet.rendering.PortletExecutionManagerMXBean;
import org.jasig.portal.portlet.rendering.PortletRenderResult;
import org.jasig.portal.portlet.rendering.QueuedEvent;
import org.jasig.portal.portlet.rendering.worker.IPortletActionExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletEventExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletFailureExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletRenderExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletResourceExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletWorkerFactory;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.WebUtils;

@ManagedResource(value="uPortal:section=Framework,name=PortletExecutionManager")
@Service(value="portletExecutionManager")
public class PortletExecutionManager
extends HandlerInterceptorAdapter
implements IPortletExecutionManager,
IPortletExecutionInterceptor,
PortletExecutionManagerMXBean {
    private static final long DEBUG_TIMEOUT = TimeUnit.HOURS.toMillis(1L);
    private static final String PORTLET_HEADER_RENDERING_MAP = PortletExecutionManager.class.getName() + ".PORTLET_HEADER_RENDERING_MAP";
    private static final String PORTLET_RENDERING_MAP = PortletExecutionManager.class.getName() + ".PORTLET_RENDERING_MAP";
    protected static final String SESSION_ATTRIBUTE__PORTLET_FAILURE_CAUSE_MAP = PortletExecutionManager.class.getName() + ".PORTLET_FAILURE_CAUSE_MAP";
    protected static final String PORTLET_RENDER_HEADERS_OPTION = "javax.portlet.renderHeaders";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Queue<IPortletExecutionWorker<?>> hungWorkers = new ConcurrentLinkedQueue();
    private final ConcurrentMap<IPortletDescriptorKey, AtomicInteger> executionCount = ConcurrentMapUtils.makeDefaultsMap((Function)new /* Unavailable Anonymous Inner Class!! */);
    private boolean ignoreTimeouts = false;
    private int extendedTimeoutExecutions = 5;
    private long extendedTimeoutMultiplier = 20L;
    private int maxEventIterations = 100;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEventCoordinationService eventCoordinationService;
    private IPortletWorkerFactory portletWorkerFactory;
    private IPortletExecutionEventFactory portletExecutionEventFactory;

    @Value(value="${org.jasig.portal.portlet.maxEventIterations:100}")
    public void setMaxEventIterations(int maxEventIterations) {
        this.maxEventIterations = maxEventIterations;
    }

    public int getMaxEventIterations() {
        return this.maxEventIterations;
    }

    @Value(value="${org.jasig.portal.portlet.ignoreTimeout}")
    public void setIgnoreTimeouts(boolean ignoreTimeouts) {
        this.ignoreTimeouts = ignoreTimeouts;
    }

    public boolean isIgnoreTimeouts() {
        return this.ignoreTimeouts;
    }

    @Value(value="${org.jasig.portal.portlet.extendedTimeoutExecutions:5}")
    public void setExtendedTimeoutExecutions(int extendedTimeoutExecutions) {
        this.extendedTimeoutExecutions = extendedTimeoutExecutions;
    }

    public int getExtendedTimeoutExecutions() {
        return this.extendedTimeoutExecutions;
    }

    @Value(value="${org.jasig.portal.portlet.extendedTimeoutMultiplier:20}")
    public void setExtendedTimeoutMultiplier(long extendedTimeoutMultiplier) {
        this.extendedTimeoutMultiplier = extendedTimeoutMultiplier;
    }

    public long getExtendedTimeoutMultiplier() {
        return this.extendedTimeoutMultiplier;
    }

    public Map<String, Integer> getPortletExecutionCounts() {
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
        for (Map.Entry entry : this.executionCount.entrySet()) {
            IPortletDescriptorKey key = (IPortletDescriptorKey)entry.getKey();
            AtomicInteger value = (AtomicInteger)entry.getValue();
            counts.put(key.getWebAppName() + "/" + key.getPortletName(), value.get());
        }
        return counts;
    }

    @Autowired
    public void setPortletWorkerFactory(IPortletWorkerFactory portletWorkerFactory) {
        this.portletWorkerFactory = portletWorkerFactory;
    }

    @Autowired
    public void setEventCoordinationService(IPortletEventCoordinationService eventCoordinationService) {
        this.eventCoordinationService = eventCoordinationService;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletExecutionEventFactory(IPortletExecutionEventFactory portletExecutionEventFactory) {
        this.portletExecutionEventFactory = portletExecutionEventFactory;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Map portletHeaderRenderingMap = this.getPortletHeaderRenderingMap(request);
        for (IPortletRenderExecutionWorker portletRenderExecutionWorker : portletHeaderRenderingMap.values()) {
            this.checkWorkerCompletion(request, portletRenderExecutionWorker);
        }
        Map portletRenderingMap = this.getPortletRenderingMap(request);
        for (IPortletRenderExecutionWorker portletRenderExecutionWorker : portletRenderingMap.values()) {
            this.checkWorkerCompletion(request, portletRenderExecutionWorker);
        }
    }

    protected void checkWorkerCompletion(HttpServletRequest request, IPortletRenderExecutionWorker portletRenderExecutionWorker) {
        if (!portletRenderExecutionWorker.isRetrieved()) {
            IPortletWindowId portletWindowId = portletRenderExecutionWorker.getPortletWindowId();
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
            this.logger.warn("Portlet worker started but never retrieved for: " + portletWindow + ": If random portlet fnames it may be users switching tabs before page is done rendering. " + "If repeatedly occurring with one portlet fname see " + "http://jasig.275507.n4.nabble.com/Portlet-worker-started-but-never-retrieved-td4580698.html");
            try {
                portletRenderExecutionWorker.get(0L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!portletRenderExecutionWorker.isComplete()) {
            this.cancelWorker(request, (IPortletExecutionWorker)portletRenderExecutionWorker);
        }
    }

    protected void cancelWorker(HttpServletRequest request, IPortletExecutionWorker<?> portletExecutionWorker) {
        IPortletWindowId portletWindowId = portletExecutionWorker.getPortletWindowId();
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        this.logger.warn("{} has not completed, adding to hung-worker cleanup queue: {}", portletExecutionWorker, (Object)portletWindow);
        portletExecutionWorker.cancel();
        this.portletExecutionEventFactory.publishPortletHungEvent(request, (Object)this, portletExecutionWorker);
        this.hungWorkers.offer(portletExecutionWorker);
    }

    @Scheduled(fixedRate=1000L)
    public void cleanupHungWorkers() {
        if (this.hungWorkers.isEmpty()) {
            return;
        }
        Iterator workerItr = this.hungWorkers.iterator();
        while (workerItr.hasNext()) {
            IPortletExecutionWorker worker = (IPortletExecutionWorker)workerItr.next();
            if (worker.isComplete()) {
                workerItr.remove();
                this.logger.debug("{} has completed and is removed from the hung worker queue after {} cancels", (Object)worker, (Object)worker.getCancelCount());
                this.portletExecutionEventFactory.publishPortletHungCompleteEvent((Object)this, worker);
                continue;
            }
            int cancelCount = worker.getCancelCount();
            if (cancelCount % 150 == 0) {
                this.logger.warn("{} is still hung, cancel has been called {} times", (Object)worker, (Object)cancelCount);
            } else {
                this.logger.debug("{} is still hung, cancel has been called {} times", (Object)worker, (Object)cancelCount);
            }
            worker.cancel();
        }
    }

    public void preSubmit(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
    }

    public void preExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
    }

    public void postExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context, Exception e) {
        IPortletWindowId portletWindowId = context.getPortletWindowId();
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        IPortletDescriptorKey portletDescriptorKey = portletDefinition.getPortletDescriptorKey();
        AtomicInteger counter = (AtomicInteger)this.executionCount.get(portletDescriptorKey);
        counter.incrementAndGet();
    }

    public void doPortletAction(IPortletEntityId portletEntityId, HttpServletRequest request, HttpServletResponse response) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindow(request, portletEntityId);
        this.doPortletAction(portletWindow.getPortletWindowId(), request, response);
    }

    public void doPortletAction(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        long timeout = this.getPortletActionTimeout(portletWindowId, request);
        IPortletActionExecutionWorker portletActionExecutionWorker = this.portletWorkerFactory.createActionWorker(request, response, portletWindowId);
        portletActionExecutionWorker.submit();
        try {
            portletActionExecutionWorker.get(timeout);
        }
        catch (Exception e) {
            Map portletFailureMap = this.getPortletErrorMap(request);
            portletFailureMap.put(portletWindowId, e);
        }
        if (!portletActionExecutionWorker.isComplete()) {
            this.cancelWorker(request, (IPortletExecutionWorker)portletActionExecutionWorker);
        }
        PortletEventQueue portletEventQueue = this.eventCoordinationService.getPortletEventQueue(request);
        this.doPortletEvents(portletEventQueue, request, response);
    }

    public void doPortletEvents(PortletEventQueue eventQueue, HttpServletRequest request, HttpServletResponse response) {
        int iteration;
        if (eventQueue.getUnresolvedEvents().isEmpty()) {
            return;
        }
        LinkedHashMap<IPortletWindowId, IPortletEventExecutionWorker> eventWorkers = new LinkedHashMap<IPortletWindowId, IPortletEventExecutionWorker>();
        for (iteration = 0; iteration < this.maxEventIterations; ++iteration) {
            Map.Entry eventWorkerEntry;
            this.eventCoordinationService.resolvePortletEvents(request, eventQueue);
            for (IPortletWindowId eventWindowId : eventQueue) {
                QueuedEvent queuedEvent;
                if (eventWorkers.containsKey(eventWindowId) || (queuedEvent = eventQueue.pollEvent(eventWindowId)) == null) continue;
                Event event = queuedEvent.getEvent();
                IPortletEventExecutionWorker portletEventExecutionWorker = this.portletWorkerFactory.createEventWorker(request, response, eventWindowId, event);
                eventWorkers.put(eventWindowId, portletEventExecutionWorker);
                portletEventExecutionWorker.submit();
            }
            if (eventWorkers.isEmpty()) {
                return;
            }
            int completedEventWorkers = 0;
            Set entrySet = eventWorkers.entrySet();
            Iterator eventWorkerEntryItr = entrySet.iterator();
            while (eventWorkerEntryItr.hasNext()) {
                eventWorkerEntry = eventWorkerEntryItr.next();
                IPortletExecutionWorker eventWorker = (IPortletExecutionWorker)eventWorkerEntry.getValue();
                if (!eventWorker.isComplete()) continue;
                IPortletWindowId portletWindowId = (IPortletWindowId)eventWorkerEntry.getKey();
                this.waitForEventWorker(request, eventQueue, eventWorker, portletWindowId);
                eventWorkerEntryItr.remove();
                ++completedEventWorkers;
            }
            if (completedEventWorkers != 0) continue;
            eventWorkerEntryItr = entrySet.iterator();
            eventWorkerEntry = eventWorkerEntryItr.next();
            eventWorkerEntryItr.remove();
            IPortletWindowId portletWindowId = (IPortletWindowId)eventWorkerEntry.getKey();
            IPortletExecutionWorker eventWorker = (IPortletExecutionWorker)eventWorkerEntry.getValue();
            this.waitForEventWorker(request, eventQueue, eventWorker, portletWindowId);
        }
        if (iteration == this.maxEventIterations) {
            this.logger.error("The Event dispatching iteration maximum of " + this.maxEventIterations + " was hit, consider either raising this limit or reviewing the portlets that use events to reduce the number of events spawned");
        }
    }

    protected void waitForEventWorker(HttpServletRequest request, PortletEventQueue eventQueue, IPortletExecutionWorker<Long> eventWorker, IPortletWindowId portletWindowId) {
        long timeout = this.getPortletEventTimeout(portletWindowId, request);
        try {
            eventWorker.get(timeout);
        }
        catch (Exception e) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
            this.logger.warn(portletWindow + " threw an execption while executing an event. This chain of event handling will terminate.", (Throwable)e);
        }
        if (!eventWorker.isComplete()) {
            this.cancelWorker(request, eventWorker);
        }
    }

    public void startPortletHeaderRender(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow != null) {
            this.startPortletHeaderRender(portletWindow.getPortletWindowId(), request, response);
        } else {
            this.logger.debug("ignoring startPortletHeadRender since getDefaultPortletWindow returned null for subscribeId " + subscribeId);
        }
    }

    public void startPortletHeaderRender(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        if (this.doesPortletNeedHeaderWorker(portletWindowId, request)) {
            this.startPortletHeaderRenderInternal(portletWindowId, request, response);
        } else {
            this.logger.debug("ignoring startPortletHeadRender request since containerRuntimeOption is not present for portletWindowId " + portletWindowId);
        }
    }

    protected boolean doesPortletNeedHeaderWorker(IPortletWindowId portletWindowId, HttpServletRequest request) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        PortletDefinition portletDefinition = portletWindow.getPlutoPortletWindow().getPortletDefinition();
        ContainerRuntimeOption renderHeaderOption = portletDefinition.getContainerRuntimeOption(PORTLET_RENDER_HEADERS_OPTION);
        boolean result = false;
        if (renderHeaderOption != null) {
            result = renderHeaderOption.getValues().contains(Boolean.TRUE.toString());
        }
        return result;
    }

    public void startPortletRender(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (null != portletWindow) {
            this.startPortletRenderInternal(portletWindow.getPortletWindowId(), request, response);
        } else {
            this.logger.debug("skipping startPortletRender due to null result from getDefaultPortletWindow for subscribeId " + subscribeId);
        }
    }

    public void startPortletRender(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        this.startPortletRenderInternal(portletWindowId, request, response);
    }

    public void doPortletServeResource(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        long timeout = this.getPortletResourceTimeout(portletWindowId, request);
        IPortletResourceExecutionWorker resourceWorker = this.portletWorkerFactory.createResourceWorker(request, response, portletWindowId);
        resourceWorker.submit();
        try {
            resourceWorker.get(timeout);
        }
        catch (Exception e) {
            this.logger.error("resource worker failed with exception", (Throwable)e);
            try {
                if (!response.isCommitted()) {
                    response.sendError(503, "resource unavailable");
                }
            }
            catch (IOException e1) {
                this.logger.error("caught IOException trying to send error response for failed resource worker", (Throwable)e);
            }
        }
        if (!resourceWorker.isComplete()) {
            this.cancelWorker(request, (IPortletExecutionWorker)resourceWorker);
        }
    }

    public boolean isPortletRenderHeaderRequested(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        Map portletRenderingMap = this.getPortletHeaderRenderingMap(request);
        IPortletRenderExecutionWorker tracker = (IPortletRenderExecutionWorker)portletRenderingMap.get(portletWindowId);
        return tracker != null;
    }

    public boolean isPortletRenderHeaderRequested(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            this.logger.debug("returning false since getDefaultPortletWindow returned null for subscribeId " + subscribeId);
            return false;
        }
        return this.isPortletRenderHeaderRequested(portletWindow.getPortletWindowId(), request, response);
    }

    public boolean isPortletRenderRequested(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            this.logger.warn("returning false for isPortletRenderRequested due to null result for getDefaultPortletWindow on subscribeId " + subscribeId);
            return false;
        }
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        return this.isPortletRenderRequested(portletWindowId, request, response);
    }

    public boolean isPortletRenderRequested(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        Map portletRenderingMap = this.getPortletRenderingMap(request);
        IPortletRenderExecutionWorker tracker = (IPortletRenderExecutionWorker)portletRenderingMap.get(portletWindowId);
        return tracker != null;
    }

    public String getPortletHeadOutput(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        if (this.doesPortletNeedHeaderWorker(portletWindowId, request)) {
            IPortletRenderExecutionWorker tracker = this.getRenderedPortletHeaderWorker(portletWindowId, request, response);
            long timeout = this.getPortletRenderTimeout(portletWindowId, request);
            try {
                String output = tracker.getOutput(timeout);
                return output == null ? "" : output;
            }
            catch (Exception e) {
                this.logger.error("failed to render header output for " + portletWindowId, (Throwable)e);
                return "";
            }
        }
        this.logger.debug(portletWindowId + " does not produce output for header");
        return "";
    }

    public String getPortletHeadOutput(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            this.logger.warn("Could not find portlet window for layout node id, empty header content will be returned: " + subscribeId);
            return "";
        }
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        return this.getPortletHeadOutput(portletWindowId, request, response);
    }

    public String getPortletOutput(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            this.logger.warn("Could not find portlet window for layout node id, empty missing content text will be returned: " + subscribeId);
            return "This portlet does not exist or is not deployed correctly.";
        }
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        return this.getPortletOutput(portletWindowId, request, response);
    }

    public String getPortletOutput(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        IPortletRenderExecutionWorker tracker = this.getRenderedPortletBodyWorker(portletWindowId, request, response);
        long timeout = this.getPortletRenderTimeout(portletWindowId, request);
        try {
            String output = tracker.getOutput(timeout);
            return output == null ? "" : output;
        }
        catch (Exception e) {
            IPortletFailureExecutionWorker failureWorker = this.portletWorkerFactory.createFailureWorker(request, response, portletWindowId, e);
            try {
                failureWorker.submit();
                return failureWorker.getOutput(timeout);
            }
            catch (Exception e1) {
                this.logger.error("Failed to render error portlet for: " + portletWindowId, (Throwable)e1);
                return "Error Portlet Unavailable. Please contact your portal adminstrators.";
            }
        }
    }

    public long getPortletRenderTime(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        try {
            PortletRenderResult portletRenderResult = this.getPortletRenderResult(portletWindowId, request, response);
            return portletRenderResult.getRenderTime();
        }
        catch (Exception e) {
            this.logger.warn("unable to get portlet render time, returning -1 " + portletWindowId);
            return -1L;
        }
    }

    public String getPortletTitle(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            this.logger.warn("Could not find portlet window for layout node id, empty title content will be returned: " + subscribeId);
            return "";
        }
        return this.getPortletTitle(portletWindow.getPortletWindowId(), request, response);
    }

    public String getPortletTitle(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletWindowId, request);
        IPortletDefinitionParameter disableDynamicTitle = portletDefinition.getParameter("disableDynamicTitle");
        if (disableDynamicTitle == null || !Boolean.parseBoolean(disableDynamicTitle.getValue())) {
            try {
                String title;
                PortletRenderResult portletRenderResult = this.getPortletRenderResult(portletWindowId, request, response);
                if (portletRenderResult != null && (title = portletRenderResult.getTitle()) != null) {
                    return title;
                }
            }
            catch (Exception e) {
                this.logger.warn("unable to get portlet title, falling back to title defined in channel definition for portletWindowId " + portletWindowId);
            }
        }
        String locale = response.getLocale().toString();
        return portletDefinition.getTitle(locale);
    }

    public int getPortletNewItemCount(String subscribeId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId);
        if (portletWindow == null) {
            return 0;
        }
        return this.getPortletNewItemCount(portletWindow.getPortletWindowId(), request, response);
    }

    public int getPortletNewItemCount(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        try {
            PortletRenderResult portletRenderResult = this.getPortletRenderResult(portletWindowId, request, response);
            if (portletRenderResult != null) {
                int newItemCount = portletRenderResult.getNewItemCount();
                return newItemCount;
            }
        }
        catch (Exception e) {
            this.logger.warn("unable to get portlet new item count for portletWindowId " + portletWindowId);
        }
        return 0;
    }

    public String getPortletLink(IPortletWindowId portletWindowId, String defaultPortletUrl, HttpServletRequest request, HttpServletResponse response) {
        try {
            PortletRenderResult portletRenderResult = this.getPortletRenderResult(portletWindowId, request, response);
            if (portletRenderResult != null) {
                String link = portletRenderResult.getExternalLink();
                if (StringUtils.isNotBlank((String)link)) {
                    return link;
                }
                return defaultPortletUrl;
            }
        }
        catch (Exception e) {
            this.logger.warn("unable to get portlet link count for portletWindowId " + portletWindowId);
        }
        return defaultPortletUrl;
    }

    protected final long getModifiedTimeout(IPortletDefinition portletDefinition, HttpServletRequest request, long timeout) {
        IPortletDescriptorKey portletDescriptorKey = portletDefinition.getPortletDescriptorKey();
        AtomicInteger counter = (AtomicInteger)this.executionCount.get(portletDescriptorKey);
        int executionCount = counter.get();
        if (executionCount > this.extendedTimeoutExecutions) {
            return timeout;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Modifying timeout for %40s from %7s to %8s on execution %2s\n", portletDescriptorKey.toString(), timeout, timeout * this.extendedTimeoutMultiplier, executionCount));
        }
        return timeout * this.extendedTimeoutMultiplier;
    }

    protected long getPortletActionTimeout(IPortletWindowId portletWindowId, HttpServletRequest request) {
        if (this.ignoreTimeouts) {
            return DEBUG_TIMEOUT;
        }
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletWindowId, request);
        Integer actionTimeout = portletDefinition.getActionTimeout();
        if (actionTimeout != null) {
            return this.getModifiedTimeout(portletDefinition, request, (long)actionTimeout.intValue());
        }
        return this.getModifiedTimeout(portletDefinition, request, (long)portletDefinition.getTimeout());
    }

    protected long getPortletEventTimeout(IPortletWindowId portletWindowId, HttpServletRequest request) {
        if (this.ignoreTimeouts) {
            return DEBUG_TIMEOUT;
        }
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletWindowId, request);
        Integer eventTimeout = portletDefinition.getEventTimeout();
        if (eventTimeout != null) {
            return this.getModifiedTimeout(portletDefinition, request, (long)eventTimeout.intValue());
        }
        return this.getModifiedTimeout(portletDefinition, request, (long)portletDefinition.getTimeout());
    }

    protected long getPortletRenderTimeout(IPortletWindowId portletWindowId, HttpServletRequest request) {
        if (this.ignoreTimeouts) {
            return DEBUG_TIMEOUT;
        }
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletWindowId, request);
        Integer renderTimeout = portletDefinition.getRenderTimeout();
        if (renderTimeout != null) {
            return this.getModifiedTimeout(portletDefinition, request, (long)renderTimeout.intValue());
        }
        return this.getModifiedTimeout(portletDefinition, request, (long)portletDefinition.getTimeout());
    }

    protected long getPortletResourceTimeout(IPortletWindowId portletWindowId, HttpServletRequest request) {
        if (this.ignoreTimeouts) {
            return DEBUG_TIMEOUT;
        }
        IPortletDefinition portletDefinition = this.getPortletDefinition(portletWindowId, request);
        Integer resourceTimeout = portletDefinition.getResourceTimeout();
        if (resourceTimeout != null) {
            return this.getModifiedTimeout(portletDefinition, request, (long)resourceTimeout.intValue());
        }
        return this.getModifiedTimeout(portletDefinition, request, (long)portletDefinition.getTimeout());
    }

    protected IPortletDefinition getPortletDefinition(IPortletWindowId portletWindowId, HttpServletRequest request) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity parentPortletEntity = portletWindow.getPortletEntity();
        return parentPortletEntity.getPortletDefinition();
    }

    protected IPortletRenderExecutionWorker getRenderedPortletHeaderWorker(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        Map portletHeaderRenderingMap = this.getPortletHeaderRenderingMap(request);
        IPortletRenderExecutionWorker portletHeaderRenderWorker = (IPortletRenderExecutionWorker)portletHeaderRenderingMap.get(portletWindowId);
        if (portletHeaderRenderWorker == null) {
            portletHeaderRenderWorker = this.startPortletHeaderRenderInternal(portletWindowId, request, response);
        }
        return portletHeaderRenderWorker;
    }

    protected IPortletRenderExecutionWorker getRenderedPortletBodyWorker(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        Map portletRenderingMap = this.getPortletRenderingMap(request);
        IPortletRenderExecutionWorker tracker = (IPortletRenderExecutionWorker)portletRenderingMap.get(portletWindowId);
        if (tracker == null) {
            tracker = this.startPortletRenderInternal(portletWindowId, request, response);
        }
        return tracker;
    }

    protected PortletRenderResult getPortletRenderResult(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPortletRenderExecutionWorker tracker = this.getRenderedPortletBodyWorker(portletWindowId, request, response);
        long timeout = this.getPortletRenderTimeout(portletWindowId, request);
        return (PortletRenderResult)tracker.get(timeout);
    }

    protected IPortletRenderExecutionWorker startPortletHeaderRenderInternal(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        IPortletRenderExecutionWorker portletHeaderRenderWorker = this.portletWorkerFactory.createRenderHeaderWorker(request, response, portletWindowId);
        portletHeaderRenderWorker.submit();
        Map portletHeaderRenderingMap = this.getPortletHeaderRenderingMap(request);
        portletHeaderRenderingMap.put(portletWindowId, portletHeaderRenderWorker);
        return portletHeaderRenderWorker;
    }

    protected IPortletRenderExecutionWorker startPortletRenderInternal(IPortletWindowId portletWindowId, HttpServletRequest request, HttpServletResponse response) {
        Map portletFailureMap = this.getPortletErrorMap(request);
        Exception cause = (Exception)portletFailureMap.remove(portletWindowId);
        Object portletRenderExecutionWorker = null != cause ? this.portletWorkerFactory.createFailureWorker(request, response, portletWindowId, cause) : this.portletWorkerFactory.createRenderWorker(request, response, portletWindowId);
        portletRenderExecutionWorker.submit();
        Map portletRenderingMap = this.getPortletRenderingMap(request);
        portletRenderingMap.put(portletWindowId, portletRenderExecutionWorker);
        return portletRenderExecutionWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<IPortletWindowId, IPortletRenderExecutionWorker> getPortletHeaderRenderingMap(HttpServletRequest request) {
        Object object = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker> portletRenderingMap = (ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker>)request.getAttribute(PORTLET_HEADER_RENDERING_MAP);
            if (portletRenderingMap == null) {
                portletRenderingMap = new ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker>();
                request.setAttribute(PORTLET_HEADER_RENDERING_MAP, portletRenderingMap);
            }
            return portletRenderingMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<IPortletWindowId, IPortletRenderExecutionWorker> getPortletRenderingMap(HttpServletRequest request) {
        Object object = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker> portletRenderingMap = (ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker>)request.getAttribute(PORTLET_RENDERING_MAP);
            if (portletRenderingMap == null) {
                portletRenderingMap = new ConcurrentHashMap<IPortletWindowId, IPortletRenderExecutionWorker>();
                request.setAttribute(PORTLET_RENDERING_MAP, portletRenderingMap);
            }
            return portletRenderingMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<IPortletWindowId, Exception> getPortletErrorMap(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            ConcurrentHashMap<IPortletWindowId, Exception> portletFailureMap = (ConcurrentHashMap<IPortletWindowId, Exception>)session.getAttribute(SESSION_ATTRIBUTE__PORTLET_FAILURE_CAUSE_MAP);
            if (portletFailureMap == null) {
                portletFailureMap = new ConcurrentHashMap<IPortletWindowId, Exception>();
                session.setAttribute(SESSION_ATTRIBUTE__PORTLET_FAILURE_CAUSE_MAP, portletFailureMap);
            }
            return portletFailureMap;
        }
    }
}

