/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.WriterOutputStream;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;

public class RenderPortletOutputHandler
implements PortletOutputHandler {
    private final StringBuilderWriter writer = new StringBuilderWriter();
    private final PrintWriter printWriter = new PrintWriter((Writer)this.writer);
    private final String characterEncoding;
    private OutputStream writerOutputStream;
    private int bufferSize = Integer.MAX_VALUE;
    private String contentType;

    public RenderPortletOutputHandler(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getOutput() {
        this.flushBuffer();
        return this.writer.getBuilder().toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public OutputStream getOutputStream() {
        if (this.writerOutputStream == null) {
            this.writerOutputStream = new WriterOutputStream((Writer)this.printWriter, this.characterEncoding);
        }
        return this.writerOutputStream;
    }

    public void flushBuffer() {
        if (this.writerOutputStream != null) {
            try {
                this.writerOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.printWriter.flush();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.contentType = null;
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.flushBuffer();
        StringBuilder builder = this.writer.getBuilder();
        if (builder.length() > 0) {
            builder.delete(0, builder.length());
        }
    }

    public void setBufferSize(int size) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

