/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortletHungCompleteEvent;
import org.jasig.portal.events.PortletHungEvent;
import org.jasig.portal.portlet.rendering.worker.HungWorkerAnalyzerMXBean;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionWorker;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;

@ManagedResource(value="uPortal:section=Framework,name=HungWorkerAnalyzer")
@Service(value="hungWorkerAnalyzer")
public class HungWorkerAnalyzer
implements ApplicationListener<PortalEvent>,
InitializingBean,
IPortletExecutionInterceptor,
HungWorkerAnalyzerMXBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, AtomicInteger> hungPortletCounts = new ConcurrentHashMap();
    private final Map<String, Integer> hungPortletCountsView = Maps.transformValues((Map)this.hungPortletCounts, (Function)new /* Unavailable Anonymous Inner Class!! */);
    private final AtomicInteger hungPortletCountTotal = new AtomicInteger();
    @Deprecated
    private Integer numberPermittedErrantByFname;
    private ThreadPoolExecutor portletThreadPool;
    private double percentPermittedErrantByFname = 0.1;

    @Value(value="${org.jasig.portal.portlet.numberPermittedErrantByFname:}")
    @Deprecated
    public void setNumberPermittedErrantByFname(Integer numberPermittedErrantByFname) {
        this.numberPermittedErrantByFname = numberPermittedErrantByFname;
    }

    @Value(value="${org.jasig.portal.portlet.percentPermittedErrantByFname:.1}")
    public void setPercentPermittedErrantByFname(double percentPermittedErrantByFname) {
        this.percentPermittedErrantByFname = percentPermittedErrantByFname;
    }

    public double getPercentPermittedErrantByFname() {
        return this.percentPermittedErrantByFname;
    }

    @Autowired
    public void setPortletThreadPool(@Qualifier(value="portletThreadPool") ExecutorService portletThreadPool) {
        this.portletThreadPool = (ThreadPoolExecutor)portletThreadPool;
    }

    public int getHungPortletCountTotal() {
        return this.hungPortletCountTotal.get();
    }

    public Map<String, Integer> getHungPortletCounts() {
        return this.hungPortletCountsView;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.numberPermittedErrantByFname != null) {
            if (this.numberPermittedErrantByFname == 0) {
                this.percentPermittedErrantByFname = 0.0;
            } else if (this.numberPermittedErrantByFname > 0) {
                this.percentPermittedErrantByFname = (double)this.numberPermittedErrantByFname.intValue() / (double)this.portletThreadPool.getMaximumPoolSize();
            }
        }
    }

    public void onApplicationEvent(PortalEvent event) {
        if (event instanceof PortletHungEvent) {
            IPortletExecutionWorker worker = ((PortletHungEvent)event).getWorker();
            this.countHungWorker(worker);
        } else if (event instanceof PortletHungCompleteEvent) {
            IPortletExecutionWorker worker = ((PortletHungCompleteEvent)event).getWorker();
            this.countHungCompleteWorker(worker);
        }
    }

    protected void countHungWorker(IPortletExecutionWorker<?> worker) {
        String portletFname = worker.getPortletFname();
        AtomicInteger count = (AtomicInteger)this.hungPortletCounts.get(portletFname);
        if (count == null) {
            count = (AtomicInteger)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.hungPortletCounts, (Object)portletFname, (Object)new AtomicInteger());
        }
        int hungWorkerCount = count.incrementAndGet();
        this.hungPortletCountTotal.incrementAndGet();
        this.logState(portletFname, hungWorkerCount);
    }

    protected void countHungCompleteWorker(IPortletExecutionWorker<?> worker) {
        String portletFname = worker.getPortletFname();
        AtomicInteger count = (AtomicInteger)this.hungPortletCounts.get(portletFname);
        if (count != null) {
            int hungWorkerCount = count.decrementAndGet();
            this.logState(portletFname, hungWorkerCount);
        }
        this.hungPortletCountTotal.decrementAndGet();
    }

    private void logState(String portletFname, int hungWorkerCount) {
        int maximumPoolSize = this.portletThreadPool.getMaximumPoolSize();
        int availableWorkers = maximumPoolSize - this.portletThreadPool.getActiveCount();
        double hungWorkerLimit = this.percentPermittedErrantByFname * (double)availableWorkers;
        String msg = "Portlet '{}' has {} hung workers out of {} total and {} available workers with a limit of {} hung workers.";
        Object[] args = new Object[]{portletFname, hungWorkerCount, maximumPoolSize, availableWorkers, hungWorkerLimit};
        if ((double)hungWorkerCount >= Math.ceil(hungWorkerLimit)) {
            this.logger.warn("Portlet '{}' has {} hung workers out of {} total and {} available workers with a limit of {} hung workers.", args);
        } else if ((double)hungWorkerCount >= Math.ceil(hungWorkerLimit / 2.0)) {
            this.logger.info("Portlet '{}' has {} hung workers out of {} total and {} available workers with a limit of {} hung workers.", args);
        } else {
            this.logger.debug("Portlet '{}' has {} hung workers out of {} total and {} available workers with a limit of {} hung workers.", args);
        }
    }

    public void preSubmit(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
        if (this.percentPermittedErrantByFname <= 0.0) {
            return;
        }
        String portletFname = context.getPortletFname();
        AtomicInteger count = (AtomicInteger)this.hungPortletCounts.get(portletFname);
        if (count == null) {
            return;
        }
        int hungWorkers = count.get();
        if (hungWorkers == 0) {
            return;
        }
        int maximumPoolSize = this.portletThreadPool.getMaximumPoolSize();
        int availableWorkers = maximumPoolSize - this.portletThreadPool.getActiveCount();
        double hungWorkerLimit = this.percentPermittedErrantByFname * (double)availableWorkers;
        if ((double)hungWorkers < Math.ceil(hungWorkerLimit)) {
            return;
        }
        String msg = "Denying worker execution for " + portletFname + " that has " + hungWorkers + " hung threads over limit of " + hungWorkerLimit + " with " + availableWorkers + " threads of " + maximumPoolSize + " available";
        this.logger.info(msg);
        throw new IllegalStateException(msg);
    }

    public void preExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
    }

    public void postExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context, Exception e) {
    }
}

