/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaPortletExecutionInterceptor
extends JpaAccessor
implements IPortletExecutionInterceptor {
    private static final String IS_NEW = JpaPortletExecutionInterceptor.class.getName() + ".IS_NEW";
    private static final String ENTITY_MANAGER_FACTORY = JpaPortletExecutionInterceptor.class.getName() + ".ENTITY_MANAGER_FACTORY";

    public void preExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
        EntityManager em = this.getTransactionalEntityManager();
        boolean isNewEm = false;
        if (em == null) {
            this.logger.debug((Object)"Creating new EntityManager for JpaInterceptor invocation");
            em = this.createEntityManager();
            isNewEm = true;
            TransactionSynchronizationManager.bindResource((Object)this.getEntityManagerFactory(), (Object)new EntityManagerHolder(em));
            context.setExecutionAttribute(ENTITY_MANAGER_FACTORY, (Object)em);
        }
        context.setExecutionAttribute(IS_NEW, (Object)isNewEm);
    }

    public void postExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context, Exception e) {
        boolean isNewEm = (Boolean)context.getExecutionAttribute(IS_NEW);
        if (isNewEm) {
            TransactionSynchronizationManager.unbindResource((Object)this.getEntityManagerFactory());
            EntityManager em = (EntityManager)context.getExecutionAttribute(ENTITY_MANAGER_FACTORY);
            EntityManagerFactoryUtils.closeEntityManager((EntityManager)em);
        }
    }

    public void preSubmit(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
    }
}

