/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.portlets.PortletPreferencesJsonDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PortletPreferencesJsonDaoImpl
implements PortletPreferencesJsonDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper mapper;

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void storeJson(PortletPreferences prefs, String key, Object data) throws IOException, ReadOnlyException, ValidatorException {
        String configData = this.mapper.writeValueAsString(data);
        prefs.setValue(key, configData);
        prefs.store();
    }

    public <E> E getJson(PortletPreferences prefs, String key, Class<E> type) throws IOException {
        String prefValue = StringUtils.trimToNull((String)prefs.getValue(key, null));
        if (prefValue == null) {
            return null;
        }
        return (E)this.mapper.readValue(prefValue, type);
    }

    public JsonNode getJsonNode(PortletPreferences prefs, String key) throws IOException {
        String prefValue = StringUtils.trimToNull((String)prefs.getValue(key, null));
        if (prefValue == null) {
            return this.mapper.createObjectNode();
        }
        return this.mapper.readTree(prefValue);
    }
}

