/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.activity;

import com.google.visualization.datasource.base.TypeMismatchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.action.SearchRequestAggregation;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationDao;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationImpl;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregation;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDao;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKeyImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.login.LoginAggregation;
import org.jasig.portal.events.aggr.login.LoginAggregationDao;
import org.jasig.portal.events.aggr.login.LoginAggregationKeyImpl;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.portlets.activity.PortalActivity;
import org.jasig.portal.portlets.activity.PortalGroupActivity;
import org.jasig.portal.portlets.activity.SearchInfo;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class ActivityController {
    private static final String PREFERENCE_PREFIX = "PortalActivity." + ActivityController.class.getSimpleName() + ".";
    private static final String PREFERENCE_MASTER_GROUP = PREFERENCE_PREFIX + "masterGroup";
    private static final String PREFERENCE_DISPLAY_GROUPS = PREFERENCE_PREFIX + "displayGroups";
    private static final String PREFERENCE_DISPLAY_OTHER = PREFERENCE_PREFIX + "displayOther";
    private static final String PREFERENCE_UNIQUE_LOGINS = PREFERENCE_PREFIX + "uniqueLogins";
    private static final String PREFERENCE_SHOW_SEACHES = PREFERENCE_PREFIX + "showSearches";
    private static final String DEFAULT_PREFERENCE_MASTER_GROUP = "Everyone";
    private static final String[] DEFAULT_PREFERENCE_DISPLAY_GROUPS = new String[0];
    private static final String DEFAULT_PREFERENCE_DISPLAY_OTHER = "true";
    private static final String DEFAULT_PREFERENCE_UNIQUE_LOGINS = "true";
    private static final String DEFAULT_PREFERENCE_SHOW_SEARCHES = "true";
    private static final int NOW = 1;
    private static final int TODAY = 2;
    private static final int YESTERDAY = 3;
    private AggregatedGroupLookupDao aggregatedGroupLookupDao;
    private SearchRequestAggregationDao<SearchRequestAggregation> searchRequestAggregationDao;
    private ConcurrentUserAggregationDao<ConcurrentUserAggregation> concurrentUserAggregationDao;
    private LoginAggregationDao<LoginAggregation> loginAggregationDao;

    @Autowired
    public void setAggregatedGroupLookupDao(AggregatedGroupLookupDao aggregatedGroupLookupDao) {
        this.aggregatedGroupLookupDao = aggregatedGroupLookupDao;
    }

    @Autowired
    public void setSearchRequestAggregationDao(SearchRequestAggregationDao<SearchRequestAggregation> searchRequestAggregationDao) {
        this.searchRequestAggregationDao = searchRequestAggregationDao;
    }

    @Autowired
    public void setConcurrentUserAggregationDao(ConcurrentUserAggregationDao<ConcurrentUserAggregation> concurrentUserAggregationDao) {
        this.concurrentUserAggregationDao = concurrentUserAggregationDao;
    }

    @Autowired
    public void setLoginAggregationDao(LoginAggregationDao<LoginAggregation> loginAggregationDao) {
        this.loginAggregationDao = loginAggregationDao;
    }

    @RenderMapping
    public ModelAndView summary(PortletRequest request) throws TypeMismatchException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortalActivity now = this.buildPortalActivity(request, 1);
        PortalActivity today = this.buildPortalActivity(request, 2);
        PortalActivity yesterday = this.buildPortalActivity(request, 3);
        model.put("usageNow", now);
        model.put("usageToday", today);
        model.put("usageYesterday", yesterday);
        List popularSearchTerms = Collections.emptyList();
        PortletPreferences prefs = request.getPreferences();
        Boolean showSearches = Boolean.valueOf(prefs.getValue(PREFERENCE_SHOW_SEACHES, "true"));
        if (showSearches.booleanValue()) {
            popularSearchTerms = this.getPopularSearchTerms();
        }
        model.put("showSearches", showSearches);
        model.put("popularSearchTerms", popularSearchTerms);
        return new ModelAndView("jsp/Activity/activity", model);
    }

    private PortalActivity buildPortalActivity(PortletRequest request, int timeframe) {
        int otherTotal;
        AggregationInterval interval;
        DateTime begin;
        DateTime end;
        PortletPreferences prefs = request.getPreferences();
        ArrayList<PortalGroupActivity> groupActivities = new ArrayList<PortalGroupActivity>();
        switch (timeframe) {
            case 1: {
                end = new DateTime();
                begin = end.minusHours(1);
                interval = AggregationInterval.FIVE_MINUTE;
                break;
            }
            case 2: {
                begin = new DateMidnight().toDateTime();
                end = begin.plusDays(1);
                interval = AggregationInterval.DAY;
                break;
            }
            case 3: {
                end = new DateMidnight().toDateTime().minusSeconds(1);
                begin = end.minusDays(1);
                interval = AggregationInterval.DAY;
                break;
            }
            default: {
                end = new DateTime();
                begin = end.minusHours(1);
                interval = AggregationInterval.HOUR;
            }
        }
        String masterGroup = prefs.getValue(PREFERENCE_MASTER_GROUP, DEFAULT_PREFERENCE_MASTER_GROUP);
        List<String> displayGroups = Arrays.asList(prefs.getValues(PREFERENCE_DISPLAY_GROUPS, DEFAULT_PREFERENCE_DISPLAY_GROUPS));
        boolean displayOther = Boolean.valueOf(prefs.getValue(PREFERENCE_DISPLAY_OTHER, "true"));
        int masterTotal = 0;
        int absTotal = 0;
        int subTotal = 0;
        switch (timeframe) {
            case 1: {
                for (AggregatedGroupMapping group : this.concurrentUserAggregationDao.getAggregatedGroupMappings()) {
                    ConcurrentUserAggregationKeyImpl key = new ConcurrentUserAggregationKeyImpl(interval, group);
                    List aggregations = this.concurrentUserAggregationDao.getAggregations(begin, end, (BaseAggregationKey)key, new AggregatedGroupMapping[0]);
                    if (aggregations.size() == 0) continue;
                    ConcurrentUserAggregation aggregation = (ConcurrentUserAggregation)aggregations.get(0);
                    int groupTotal = aggregation.getConcurrentUsers();
                    absTotal += aggregation.getConcurrentUsers();
                    if (group.getGroupName().equalsIgnoreCase(masterGroup)) {
                        masterTotal = groupTotal;
                    } else {
                        subTotal += groupTotal;
                    }
                    if (group.getGroupName().equals(masterGroup) || !displayGroups.isEmpty() && !displayGroups.contains(group.getGroupName())) continue;
                    PortalGroupActivity groupActivity = new PortalGroupActivity(group.getGroupName(), groupTotal);
                    groupActivities.add(groupActivity);
                }
                break;
            }
            default: {
                String uniqueLoginsPref = prefs.getValue(PREFERENCE_UNIQUE_LOGINS, "true");
                Boolean uniqueLogins = Boolean.valueOf(uniqueLoginsPref);
                for (AggregatedGroupMapping group : this.loginAggregationDao.getAggregatedGroupMappings()) {
                    LoginAggregationKeyImpl key = new LoginAggregationKeyImpl(interval, group);
                    List aggregations = this.loginAggregationDao.getAggregations(begin, end, (BaseAggregationKey)key, new AggregatedGroupMapping[0]);
                    if (aggregations.size() == 0) continue;
                    LoginAggregation aggregation = (LoginAggregation)aggregations.get(0);
                    int groupTotal = this.getAggregationLoginCount(aggregation, uniqueLogins.booleanValue());
                    absTotal += groupTotal;
                    if (group.getGroupName().equalsIgnoreCase(masterGroup)) {
                        masterTotal = groupTotal;
                    } else {
                        subTotal += groupTotal;
                    }
                    if (group.getGroupName().equals(masterGroup) || !displayGroups.isEmpty() && !displayGroups.contains(group.getGroupName())) continue;
                    PortalGroupActivity groupActivity = new PortalGroupActivity(group.getGroupName(), groupTotal);
                    groupActivities.add(groupActivity);
                }
            }
        }
        if (displayOther && (otherTotal = masterTotal - subTotal) > 0) {
            PortalGroupActivity otherGroup = new PortalGroupActivity("Other", otherTotal);
            groupActivities.add(otherGroup);
        }
        Collections.sort(groupActivities);
        Collections.reverse(groupActivities);
        int total = masterTotal > 0 ? masterTotal : absTotal;
        PortalActivity activity = new PortalActivity(total, groupActivities);
        return activity;
    }

    private List<SearchInfo> getPopularSearchTerms() {
        DateTime end = new DateTime();
        DateTime begin = end.minusDays(1);
        IEntityGroup everyone = GroupService.getRootGroup(IPerson.class);
        AggregatedGroupMapping group = this.aggregatedGroupLookupDao.getGroupMapping(everyone.getKey());
        List aggregations = this.searchRequestAggregationDao.getAggregations(begin, end, AggregationInterval.FIVE_MINUTE, group, new AggregatedGroupMapping[0]);
        HashMap<String, SearchInfo> resultBuilder = new HashMap<String, SearchInfo>();
        for (SearchRequestAggregationImpl aggregation : aggregations) {
            SearchInfo info = (SearchInfo)resultBuilder.get(aggregation.getSearchTerm());
            if (info == null) {
                info = new SearchInfo(aggregation.getSearchTerm(), aggregation.getCount());
                resultBuilder.put(aggregation.getSearchTerm(), info);
                continue;
            }
            info.incrementCount(aggregation.getCount());
        }
        ArrayList<SearchInfo> results = new ArrayList<SearchInfo>(resultBuilder.values());
        Collections.sort(results);
        Collections.reverse(results);
        return results.size() > 10 ? results.subList(0, 9) : results;
    }

    private int getAggregationLoginCount(LoginAggregation aggregation, boolean unique) {
        return unique ? aggregation.getUniqueLoginCount() : aggregation.getLoginCount();
    }
}

