/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.directory;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlets.lookup.PersonLookupHelperImpl;
import org.jasig.portal.portlets.search.DirectoryAttributeType;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.PortletUrlType;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class DirectoryPortletController {
    private static final String MAXIMIZE_ON_SEARCH_PREFERENCE = "DirectoryPortletController.maximizeOnSearch";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPortalRequestUtils portalRequestUtils;
    private IPersonManager personManager;
    private PersonLookupHelperImpl lookupHelper;
    private Map<String, DirectoryAttributeType> displayAttributes;
    private List<String> directoryQueryAttributes;

    @Autowired(required=true)
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired(required=true)
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired(required=true)
    public void setPersonLookupHelper(PersonLookupHelperImpl lookupHelper) {
        this.lookupHelper = lookupHelper;
    }

    @Resource(name="directoryDisplayAttributes")
    public void setDirectoryDisplayAttributes(Map<String, DirectoryAttributeType> attributes) {
        this.displayAttributes = attributes;
    }

    @Resource(name="directoryQueryAttributes")
    public void setDirectoryQueryAttributes(List<String> attributes) {
        this.directoryQueryAttributes = attributes;
    }

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void search2(EventRequest request, EventResponse response) {
        Event event = request.getEvent();
        SearchRequest query = (SearchRequest)event.getValue();
        List people = this.searchDirectory(query.getSearchTerms(), (PortletRequest)request);
        if (people.size() > 0) {
            SearchResults results = new SearchResults();
            results.setQueryId(query.getQueryId());
            results.setWindowId(request.getWindowID());
            for (IPersonAttributes person : people) {
                SearchResult result = new SearchResult();
                result.setTitle((String)person.getAttributeValue("displayName"));
                result.getType().add("Directory");
                PortletUrl url = new PortletUrl();
                url.setType(PortletUrlType.RENDER);
                url.setPortletMode("VIEW");
                url.setWindowState("maximized");
                PortletUrlParameter actionParam = new PortletUrlParameter();
                actionParam.setName("action");
                actionParam.getValue().add("findByUsername");
                url.getParam().add(actionParam);
                PortletUrlParameter usernameParam = new PortletUrlParameter();
                usernameParam.setName("username");
                usernameParam.getValue().add(person.getName());
                url.getParam().add(usernameParam);
                result.setPortletUrl(url);
                results.getSearchResult().add(result);
            }
            response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)results);
        }
    }

    @RenderMapping
    public ModelAndView search(RenderRequest request, @RequestParam(value="query", required=false) String query) {
        boolean isMobile;
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (query != null) {
            List people = this.searchDirectory(query, (PortletRequest)request);
            model.put("query", query);
            model.put("people", people);
            model.put("attributeNames", this.displayAttributes);
        }
        String viewName = (isMobile = this.isMobile((PortletRequest)request)) ? "/jsp/Directory/mobileDirectory" : "/jsp/Directory/directory";
        return new ModelAndView(viewName, model);
    }

    @RenderMapping(params={"action=findByUsername"})
    public ModelAndView findPersonByUsername(RenderRequest request, @RequestParam String username) {
        HttpServletRequest servletRequest = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)request);
        IPerson currentUser = this.personManager.getPerson(servletRequest);
        IPersonAttributes person = this.lookupHelper.findPerson(currentUser, username);
        boolean isMobile = this.isMobile((PortletRequest)request);
        String viewName = isMobile ? "/jsp/Directory/mobileDirectory" : "/jsp/Directory/directory";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("query", username);
        model.put("people", Collections.singletonList(person));
        model.put("attributeNames", this.displayAttributes);
        return new ModelAndView(viewName, model);
    }

    @ActionMapping
    public void submitSearch(ActionRequest request, ActionResponse response, @RequestParam(value="query", required=false) String query) {
        PortletPreferences prefs = request.getPreferences();
        boolean maximize = Boolean.parseBoolean(prefs.getValue(MAXIMIZE_ON_SEARCH_PREFERENCE, "true"));
        if (maximize) {
            try {
                response.setWindowState(WindowState.MAXIMIZED);
            }
            catch (WindowStateException e) {
                this.log.warn((Object)"Failed to set the window state to MAXIMIZED", (Throwable)e);
            }
        }
        if (query != null) {
            response.setRenderParameter("query", query);
        }
    }

    @ModelAttribute(value="maxResults")
    public int getMaxResults() {
        return this.lookupHelper.getMaxResults();
    }

    protected List<IPersonAttributes> searchDirectory(String query, PortletRequest request) {
        HashMap<String, String> queryAttributes = new HashMap<String, String>();
        for (String attr : this.directoryQueryAttributes) {
            queryAttributes.put(attr, query);
        }
        HttpServletRequest servletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        IPerson currentUser = this.personManager.getPerson(servletRequest);
        List people = this.lookupHelper.searchForPeople(currentUser, queryAttributes);
        return people;
    }

    protected boolean isMobile(PortletRequest request) {
        String themeName = request.getProperty("themeName");
        return "UniversalityMobile".equals(themeName);
    }
}

