/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.groupadmin;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.groupadmin.GroupForm;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.RuntimeAuthorizationException;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupAdministrationHelper {
    public static final String GROUPS_OWNER = "UP_GROUPS";
    public static final String CREATE_PERMISSION = "CREATE_GROUP";
    public static final String DELETE_PERMISSION = "DELETE_GROUP";
    public static final String EDIT_PERMISSION = "EDIT_GROUP";
    public static final String VIEW_PERMISSION = "VIEW_GROUP";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IGroupListHelper groupListHelper;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public GroupForm getGroupForm(String key) {
        this.log.debug((Object)("Initializing group form for group key " + key));
        IEntityGroup group = GroupService.findGroup((String)key);
        GroupForm form = new GroupForm();
        form.setKey(key);
        form.setName(group.getName());
        form.setDescription(group.getDescription());
        form.setCreatorId(group.getCreatorID());
        form.setType(this.groupListHelper.getEntityType((IGroupMember)group).toString());
        Iterator groupIter = group.getMembers();
        while (groupIter.hasNext()) {
            IGroupMember child = (IGroupMember)groupIter.next();
            JsonEntityBean childBean = this.groupListHelper.getEntity(child);
            form.addMember(childBean);
        }
        return form;
    }

    public void deleteGroup(String key, IPerson deleter) {
        if (!this.canDeleteGroup(deleter, key)) {
            throw new RuntimeAuthorizationException(deleter, DELETE_PERMISSION, key);
        }
        this.log.info((Object)("Deleting group with key " + key));
        IEntityGroup group = GroupService.findGroup((String)key);
        Iterator iter = group.getContainingGroups();
        while (iter.hasNext()) {
            IEntityGroup parent = (IEntityGroup)iter.next();
            parent.removeMember((IGroupMember)group);
            parent.updateMembers();
        }
        group.delete();
    }

    public void updateGroupDetails(GroupForm groupForm, IPerson updater) {
        if (!this.canEditGroup(updater, groupForm.getKey())) {
            throw new RuntimeAuthorizationException(updater, EDIT_PERMISSION, groupForm.getKey());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating group for group form [" + groupForm.toString() + "]"));
        }
        IEntityGroup group = GroupService.findGroup((String)groupForm.getKey());
        group.setName(groupForm.getName());
        group.setDescription(groupForm.getDescription());
        group.update();
    }

    public void updateGroupMembers(GroupForm groupForm, IPerson updater) {
        if (!this.canEditGroup(updater, groupForm.getKey())) {
            throw new RuntimeAuthorizationException(updater, EDIT_PERMISSION, groupForm.getKey());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating group members for group form [" + groupForm.toString() + "]"));
        }
        IEntityGroup group = GroupService.findGroup((String)groupForm.getKey());
        Iterator groupIter = group.getMembers();
        while (groupIter.hasNext()) {
            IGroupMember child = (IGroupMember)groupIter.next();
            group.removeMember(child);
        }
        for (JsonEntityBean child : groupForm.getMembers()) {
            IEntityGroup member;
            EntityEnum type = EntityEnum.getEntityEnum((String)child.getEntityTypeAsString());
            if (type.isGroup()) {
                member = GroupService.findGroup((String)child.getId());
                group.addMember((IGroupMember)member);
                continue;
            }
            member = GroupService.getGroupMember((String)child.getId(), (Class)type.getClazz());
            group.addMember((IGroupMember)member);
        }
        group.updateMembers();
    }

    public void createGroup(GroupForm groupForm, JsonEntityBean parent, IPerson creator) {
        if (!this.canCreateMemberGroup(creator, parent.getId())) {
            throw new RuntimeAuthorizationException(creator, CREATE_PERMISSION, groupForm.getKey());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new group for group form [" + groupForm.toString() + "] and parent [" + parent.toString() + "]"));
        }
        EntityEnum type = EntityEnum.getEntityEnum((String)groupForm.getType());
        IEntityGroup group = GroupService.newGroup((Class)type.getClazz());
        group.setCreatorID(creator.getUserName());
        group.setName(groupForm.getName());
        group.setDescription(groupForm.getDescription());
        for (JsonEntityBean child : groupForm.getMembers()) {
            IEntityGroup member;
            EntityEnum childType = EntityEnum.getEntityEnum((String)child.getEntityTypeAsString());
            if (childType.isGroup()) {
                member = GroupService.findGroup((String)child.getId());
                group.addMember((IGroupMember)member);
                continue;
            }
            member = GroupService.getGroupMember((String)child.getId(), (Class)type.getClazz());
            group.addMember((IGroupMember)member);
        }
        group.update();
        IEntityGroup parentGroup = GroupService.findGroup((String)parent.getId());
        parentGroup.addMember((IGroupMember)group);
        parentGroup.updateMembers();
    }

    public boolean canEditGroup(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission(GROUPS_OWNER, EDIT_PERMISSION, target);
    }

    public boolean canDeleteGroup(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission(GROUPS_OWNER, DELETE_PERMISSION, target);
    }

    public boolean canCreateMemberGroup(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission(GROUPS_OWNER, CREATE_PERMISSION, target);
    }

    public boolean canViewGroup(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission(GROUPS_OWNER, VIEW_PERMISSION, target);
    }

    protected IAuthorizationPrincipal getPrincipalForUser(IPerson person) {
        EntityIdentifier ei = person.getEntityIdentifier();
        return AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
    }
}

