/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.importexport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class ImportExportPortletController {
    private static final String OWNER = "UP_SYSTEM";
    private static final String EXPORT_PERMISSION = "EXPORT_ENTITY";
    private static final String DELETE_PERMISSION = "DELETE_ENTITY";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;
    private IPortalDataHandlerService portalDataHandlerService;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setPortalDataHandlerService(IPortalDataHandlerService portalDataHandlerService) {
        this.portalDataHandlerService = portalDataHandlerService;
    }

    @RequestMapping
    public String getImportView(PortletRequest request) {
        return "/jsp/ImportExportPortlet/import";
    }

    @RequestMapping(params={"action=export"})
    public ModelAndView getExportView(PortletRequest request) {
        HashMap<String, List> model = new HashMap<String, List>();
        Iterable exportPortalDataTypes = this.portalDataHandlerService.getExportPortalDataTypes();
        List types = this.getAllowedTypes(request, EXPORT_PERMISSION, exportPortalDataTypes);
        model.put("supportedTypes", types);
        return new ModelAndView("/jsp/ImportExportPortlet/export", model);
    }

    @RequestMapping(params={"action=delete"})
    public ModelAndView getDeleteView(PortletRequest request) {
        HashMap<String, List> model = new HashMap<String, List>();
        Iterable deletePortalDataTypes = this.portalDataHandlerService.getDeletePortalDataTypes();
        List types = this.getAllowedTypes(request, DELETE_PERMISSION, deletePortalDataTypes);
        model.put("supportedTypes", types);
        return new ModelAndView("/jsp/ImportExportPortlet/delete", model);
    }

    protected List<IPortalDataType> getAllowedTypes(PortletRequest request, String activityName, Iterable<IPortalDataType> dataTypes) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        IPerson person = this.personManager.getPerson(httpServletRequest);
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        ArrayList<IPortalDataType> results = new ArrayList<IPortalDataType>();
        for (IPortalDataType type : dataTypes) {
            String typeId = type.getTypeId();
            if (!ap.hasPermission(OWNER, activityName, typeId)) continue;
            results.add(type);
        }
        return results;
    }
}

