/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.search.google;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import org.jasig.portal.portlets.search.IPortalSearchService;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestOperations;

public class GoogleCustomSearchService
implements IPortalSearchService {
    public static final String QUERY_PARAM = "q";
    public static final String VERSION_PARAM = "v";
    public static final String USER_IP_PARAM = "userip";
    public static final String RESULT_SIZE_PARAM = "rsz";
    public static final String START_PARAM = "start";
    public static final String CUSTOM_SEARCH_PARAM = "cx";
    public static final String VERSION = "1.0";
    private static final String BASE_SEARCH_URL = "http://ajax.googleapis.com/ajax/services/search/web?q={q}&v={v}&userip={userip}&rsz={rsz}&cx={cx}";
    private String resultSize = "large";
    private String customSearchId;
    private String resultType = "googleCustom";
    private RestOperations restOperations;

    public void setResultSize(String resultSize) {
        this.resultSize = resultSize;
    }

    public void setCustomSearchId(String customSearchId) {
        this.customSearchId = customSearchId;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    @Autowired
    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public SearchResults getSearchResults(PortletRequest request, SearchRequest query) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put(VERSION_PARAM, VERSION);
        parameters.put(RESULT_SIZE_PARAM, this.resultSize);
        parameters.put(CUSTOM_SEARCH_PARAM, this.customSearchId);
        parameters.put(QUERY_PARAM, query.getSearchTerms());
        parameters.put(USER_IP_PARAM, request.getProperty("REMOTE_ADDR"));
        parameters.put(START_PARAM, query.getStartIndex());
        JsonNode googleResponse = (JsonNode)this.restOperations.getForObject(BASE_SEARCH_URL, JsonNode.class, parameters);
        SearchResults searchResults = new SearchResults();
        searchResults.setQueryId(query.getQueryId());
        List searchResultList = searchResults.getSearchResult();
        JsonNode results = googleResponse.get("responseData").get("results");
        Iterator resultItr = results.elements();
        while (resultItr.hasNext()) {
            JsonNode googleResult = (JsonNode)resultItr.next();
            SearchResult searchResult = new SearchResult();
            searchResult.setTitle(googleResult.get("title").asText());
            searchResult.setSummary(googleResult.get("content").asText());
            searchResult.setExternalUrl(googleResult.get("clicktrackUrl").asText());
            searchResult.getType().add(this.resultType);
            searchResultList.add(searchResult);
        }
        return searchResults;
    }
}

