/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.sqlquery;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portal.portlets.sqlquery.SqlQueryConfigForm;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class SqlQueryConfigurationController
extends SimpleFormController {
    private String defaultDataSource = "PortalDb";
    private String defaultView = "jsp/SqlQuery/results";

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        SqlQueryConfigForm form = (SqlQueryConfigForm)command;
        PortletPreferences prefs = request.getPreferences();
        prefs.setValue("dataSource", form.getDataSource());
        prefs.setValue("sql", form.getSqlQuery());
        prefs.setValue("view", form.getViewName());
        prefs.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    protected Object formBackingObject(PortletRequest request) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        SqlQueryConfigForm form = new SqlQueryConfigForm();
        form.setDataSource(prefs.getValue("dataSource", this.defaultDataSource));
        form.setViewName(prefs.getValue("view", this.defaultView));
        form.setSqlQuery(prefs.getValue("sql", ""));
        return form;
    }
}

