/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.BaseAggregationDateTimeComparator;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregation;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationDao;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationDiscriminator;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKey;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKeyImpl;
import org.jasig.portal.events.aggr.tabs.AggregatedTabLookupDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMappingNameComparator;
import org.jasig.portal.portlets.statistics.BaseReportForm;
import org.jasig.portal.portlets.statistics.BaseStatisticsReportController;
import org.jasig.portal.portlets.statistics.ReportTitleAndColumnDescriptionStrategy;
import org.jasig.portal.portlets.statistics.TabRenderReportForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class TabRenderStatisticsController
extends BaseStatisticsReportController<TabRenderAggregation, TabRenderAggregationKey, TabRenderAggregationDiscriminator, TabRenderReportForm> {
    private static final String DATA_TABLE_RESOURCE_ID = "tabRenderData";
    private static final String REPORT_NAME = "tabRender.totals";
    @Autowired
    private ReportTitleAndColumnDescriptionStrategy titleAndColumnDescriptionStrategy;
    @Autowired
    @Qualifier(value="jpaTabRenderAggregationDao")
    private TabRenderAggregationDao<TabRenderAggregation> tabRenderDao;
    @Autowired
    @Qualifier(value="jpaAggregatedGroupLookupDao")
    private AggregatedGroupLookupDao aggregatedGroupDao;
    @Autowired
    private AggregatedTabLookupDao aggregatedTabLookupDao;

    public void setTitleAndColumnDescriptionStrategy(ReportTitleAndColumnDescriptionStrategy titleAndColumnDescriptionStrategy) {
        this.titleAndColumnDescriptionStrategy = titleAndColumnDescriptionStrategy;
    }

    @RenderMapping(value="MAXIMIZED", params={"report=tabRender.totals"})
    public String getLoginView() throws TypeMismatchException {
        return "jsp/Statistics/reportGraph";
    }

    @ResourceMapping(value="tabRenderData")
    public ModelAndView renderTabRenderAggregationReport(TabRenderReportForm form) throws TypeMismatchException {
        return this.renderAggregationReport((BaseReportForm)form);
    }

    protected void initReportForm(TabRenderReportForm report) {
        this.setReportFormTabs(report);
    }

    private void setReportFormTabs(TabRenderReportForm report) {
        if (!report.getTabs().isEmpty()) {
            return;
        }
        Set tabs = this.getTabs();
        if (!tabs.isEmpty()) {
            report.getTabs().add(((AggregatedTabMapping)tabs.iterator().next()).getId());
        }
    }

    @ModelAttribute(value="tabs")
    public Set<AggregatedTabMapping> getTabs() {
        Set groupMappings = this.aggregatedTabLookupDao.getTabMappings();
        TreeSet<AggregatedTabMapping> sortedGroupMappings = new TreeSet<AggregatedTabMapping>(AggregatedTabMappingNameComparator.INSTANCE);
        sortedGroupMappings.addAll(groupMappings);
        return sortedGroupMappings;
    }

    public String getReportName() {
        return REPORT_NAME;
    }

    public String getReportDataResourceId() {
        return DATA_TABLE_RESOURCE_ID;
    }

    protected BaseAggregationDao<TabRenderAggregation, TabRenderAggregationKey> getBaseAggregationDao() {
        return this.tabRenderDao;
    }

    protected Set<TabRenderAggregationKey> createAggregationsQueryKeyset(Set<TabRenderAggregationDiscriminator> columnDiscriminators, TabRenderReportForm form) {
        AggregationInterval interval = form.getInterval();
        HashSet<TabRenderAggregationKey> keys = new HashSet<TabRenderAggregationKey>();
        for (TabRenderAggregationDiscriminator discriminator : columnDiscriminators) {
            keys.add((TabRenderAggregationKey)new TabRenderAggregationKeyImpl(interval, discriminator.getAggregatedGroup(), discriminator.getTabMapping()));
        }
        return keys;
    }

    protected Comparator<? super TabRenderAggregationDiscriminator> getDiscriminatorComparator() {
        return TabRenderAggregationDiscriminatorImpl.Comparator.INSTANCE;
    }

    protected Map<TabRenderAggregationDiscriminator, SortedSet<TabRenderAggregation>> createColumnDiscriminatorMap(TabRenderReportForm form) {
        TreeMap<TabRenderAggregationDiscriminator, SortedSet<TabRenderAggregation>> groupedAggregations = new TreeMap<TabRenderAggregationDiscriminator, SortedSet<TabRenderAggregation>>((Comparator<TabRenderAggregationDiscriminator>)TabRenderAggregationDiscriminatorImpl.Comparator.INSTANCE);
        List groups = form.getGroups();
        List tabs = form.getTabs();
        for (Long queryGroupId : groups) {
            AggregatedGroupMapping groupMapping = this.aggregatedGroupDao.getGroupMapping(queryGroupId.longValue());
            for (Long tabId : tabs) {
                AggregatedTabMapping tabMapping = this.aggregatedTabLookupDao.getTabMapping(tabId.longValue());
                TabRenderAggregationDiscriminatorImpl mapping = new TabRenderAggregationDiscriminatorImpl(groupMapping, tabMapping);
                TreeSet aggregations = new TreeSet(BaseAggregationDateTimeComparator.INSTANCE);
                groupedAggregations.put((TabRenderAggregationDiscriminator)mapping, aggregations);
            }
        }
        return groupedAggregations;
    }

    protected String getReportTitleAugmentation(TabRenderReportForm form) {
        Long tabId = (long)((Long)form.getTabs().iterator().next());
        String firstTabname = this.aggregatedTabLookupDao.getTabMapping(tabId.longValue()).getDisplayString();
        Long groupId = (long)((Long)form.getGroups().iterator().next());
        String firstGroupName = this.aggregatedGroupDao.getGroupMapping(groupId.longValue()).getGroupName();
        ReportTitleAndColumnDescriptionStrategy.TitleAndCount[] items = new ReportTitleAndColumnDescriptionStrategy.TitleAndCount[]{new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(firstTabname, form.getTabs().size()), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(firstGroupName, form.getGroups().size())};
        return this.titleAndColumnDescriptionStrategy.getReportTitleAugmentation(items);
    }

    protected List<ColumnDescription> getColumnDescriptions(TabRenderAggregationDiscriminator reportColumnDiscriminator, TabRenderReportForm form) {
        String tabName = reportColumnDiscriminator.getTabMapping().getDisplayString();
        String groupName = reportColumnDiscriminator.getAggregatedGroup().getGroupName();
        ReportTitleAndColumnDescriptionStrategy.TitleAndCount[] items = new ReportTitleAndColumnDescriptionStrategy.TitleAndCount[]{new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(tabName, form.getTabs().size()), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(groupName, form.getGroups().size())};
        return this.titleAndColumnDescriptionStrategy.getColumnDescriptions(items, this.showFullColumnHeaderDescriptions((BaseReportForm)form), (BaseReportForm)form);
    }

    protected List<Value> createRowValues(TabRenderAggregation aggr, TabRenderReportForm form) {
        int count = aggr != null ? aggr.getRenderCount() : 0;
        return Collections.singletonList(new NumberValue((double)count));
    }
}

