/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.swapper;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.swapper.AttributeSwapRequest;
import org.jasig.portal.portlets.swapper.IAttributeSwapperHelper;
import org.jasig.portal.portlets.swapper.OverwritingPersonAttributeDao;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.webflow.context.ExternalContext;

public class AttributeSwapperHelperImpl
implements IAttributeSwapperHelper {
    private static final String OVERRIDDEN_ATTRIBUTES = AttributeSwapperHelperImpl.class.getName() + ".OVERRIDDEN_ATTRIBUTES";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private OverwritingPersonAttributeDao overwritingPersonAttributeDao;
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;

    public OverwritingPersonAttributeDao getPersonAttributeDao() {
        return this.overwritingPersonAttributeDao;
    }

    @Required
    public void setPersonAttributeDao(OverwritingPersonAttributeDao personAttributeDao) {
        this.overwritingPersonAttributeDao = personAttributeDao;
    }

    public IPersonManager getPersonManager() {
        return this.personManager;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public Set<String> getSwappableAttributes(ExternalContext externalContext) {
        Set<String> swappableAttributes;
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("attribute-swapper.attributesForm.swappableAttributes", null);
        String[] excludedAttributes = preferences.getValues("attribute-swapper.attributesForm.swappableAttributes.exclude", null);
        if (configuredAttributes != null) {
            swappableAttributes = new LinkedHashSet<String>(Arrays.asList(configuredAttributes));
        } else {
            Set possibleAttributes = this.overwritingPersonAttributeDao.getPossibleUserAttributeNames();
            if (possibleAttributes != null) {
                swappableAttributes = new TreeSet(possibleAttributes);
            } else {
                Principal currentUser = externalContext.getCurrentUser();
                IPersonAttributes baseUserAttributes = this.getOriginalUserAttributes(currentUser.getName());
                if (baseUserAttributes != null) {
                    Map attributes = baseUserAttributes.getAttributes();
                    swappableAttributes = new LinkedHashSet(attributes.keySet());
                } else {
                    swappableAttributes = Collections.emptySet();
                }
            }
        }
        if (excludedAttributes != null) {
            for (String excludedAttribute : excludedAttributes) {
                swappableAttributes.remove(excludedAttribute);
            }
        }
        return swappableAttributes;
    }

    public IPersonAttributes getOriginalUserAttributes(String uid) {
        IPersonAttributeDao delegatePersonAttributeDao = this.overwritingPersonAttributeDao.getDelegatePersonAttributeDao();
        return delegatePersonAttributeDao.getPerson(uid);
    }

    public void populateSwapRequest(ExternalContext externalContext, AttributeSwapRequest attributeSwapRequest) {
        Principal currentUser = externalContext.getCurrentUser();
        String uid = currentUser.getName();
        IPersonAttributes person = this.overwritingPersonAttributeDao.getPerson(uid);
        Map currentAttributes = attributeSwapRequest.getCurrentAttributes();
        currentAttributes.clear();
        Set swappableAttributes = this.getSwappableAttributes(externalContext);
        for (String attribute : swappableAttributes) {
            Object value = person.getAttributeValue(attribute);
            if (value == null) continue;
            currentAttributes.put(attribute, new Attribute(String.valueOf(value)));
        }
    }

    public void swapAttributes(ExternalContext externalContext, AttributeSwapRequest attributeSwapRequest) {
        HashMap attributes = new HashMap();
        Map currentAttributes = attributeSwapRequest.getCurrentAttributes();
        this.copyAttributes(attributes, currentAttributes);
        Map attributesToCopy = attributeSwapRequest.getAttributesToCopy();
        this.copyAttributes(attributes, attributesToCopy);
        Principal currentUser = externalContext.getCurrentUser();
        String uid = currentUser.getName();
        IPersonAttributes originalUserAttributes = this.getOriginalUserAttributes(uid);
        Iterator overrideAttrEntryItr = attributes.entrySet().iterator();
        while (overrideAttrEntryItr.hasNext()) {
            Object overrideValue;
            Map.Entry overrideAttrEntry = overrideAttrEntryItr.next();
            String attribute = (String)overrideAttrEntry.getKey();
            Object originalValue = originalUserAttributes.getAttributeValue(attribute);
            if (originalValue != (overrideValue = overrideAttrEntry.getValue()) && (originalValue == null || !originalValue.equals(overrideValue))) continue;
            overrideAttrEntryItr.remove();
        }
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("attribute-swapper.attributesForm.swappableAttributes", null);
        String[] excludedAttributes = preferences.getValues("attribute-swapper.attributesForm.swappableAttributes.exclude", null);
        LinkedHashSet<String> allowedAttributes = new LinkedHashSet<String>();
        if (configuredAttributes != null) {
            allowedAttributes.addAll(Arrays.asList(configuredAttributes));
        } else {
            allowedAttributes.addAll(attributes.keySet());
        }
        if (excludedAttributes != null) {
            allowedAttributes.removeAll(Arrays.asList(excludedAttributes));
        }
        Iterator attributeItr = attributes.keySet().iterator();
        while (attributeItr.hasNext()) {
            String attribute = (String)attributeItr.next();
            if (allowedAttributes.contains(attribute)) continue;
            attributeItr.remove();
            this.logger.warn((Object)("User '" + uid + "' attempted overriding attribute '" + attribute + "' which is not allowed in the current configuration. The attribute will be ignored."));
        }
        this.logger.warn((Object)("User '" + uid + "' setting attribute overrides: " + attributes));
        this.overwritingPersonAttributeDao.setUserAttributeOverride(uid, attributes);
        HttpServletRequest portalRequest = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        IPerson person = this.personManager.getPerson(portalRequest);
        Map multivaluedAttributes = MultivaluedPersonAttributeUtils.toMultivaluedMap(attributes);
        person.setAttributes(multivaluedAttributes);
        person.setAttribute(OVERRIDDEN_ATTRIBUTES, multivaluedAttributes.keySet());
    }

    public void resetAttributes(ExternalContext externalContext) {
        Principal currentUser = externalContext.getCurrentUser();
        String uid = currentUser.getName();
        this.logger.warn((Object)("User '" + uid + "' reseting to default attributes"));
        this.overwritingPersonAttributeDao.removeUserAttributeOverride(uid);
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        HttpServletRequest portalRequest = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        IPerson person = this.personManager.getPerson(portalRequest);
        Set overriddenAttributes = (Set)person.getAttribute(OVERRIDDEN_ATTRIBUTES);
        if (overriddenAttributes != null) {
            person.setAttribute(OVERRIDDEN_ATTRIBUTES, null);
            for (String attribute : overriddenAttributes) {
                person.setAttribute(attribute, null);
            }
        }
        IPersonAttributes originalUserAttributes = this.getOriginalUserAttributes(uid);
        Map attributes = originalUserAttributes.getAttributes();
        person.setAttributes(attributes);
    }

    protected void copyAttributes(Map<String, Object> destination, Map<String, Attribute> source) {
        for (Map.Entry<String, Attribute> sourceEntry : source.entrySet()) {
            Attribute attribute = sourceEntry.getValue();
            if (attribute == null || !StringUtils.isNotEmpty((String)attribute.getValue())) continue;
            String name = sourceEntry.getKey();
            destination.put(name, attribute.getValue());
        }
    }
}

