/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.swapper;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractFlatteningPersonAttributeDao;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;
import org.springframework.beans.factory.annotation.Required;

public class OverwritingPersonAttributeDao
extends AbstractFlatteningPersonAttributeDao {
    private final IAttributeMerger attributeMerger = new ReplacingAttributeAdder();
    private Map<String, Map<String, List<Object>>> attributeOverridesMap = new ConcurrentHashMap();
    private IPersonAttributeDao delegatePersonAttributeDao;

    public IPersonAttributeDao getDelegatePersonAttributeDao() {
        return this.delegatePersonAttributeDao;
    }

    @Required
    public void setDelegatePersonAttributeDao(IPersonAttributeDao delegatePersonAttributeDao) {
        Validate.notNull((Object)delegatePersonAttributeDao, (String)"delegatePersonAttributeDao can not be null");
        this.delegatePersonAttributeDao = delegatePersonAttributeDao;
    }

    public Map<String, Map<String, List<Object>>> getAttributeOverridesMap() {
        return this.attributeOverridesMap;
    }

    public void setAttributeOverridesMap(Map<String, Map<String, List<Object>>> attributeOverridesMap) {
        Validate.notNull(attributeOverridesMap, (String)"attributeOverridesMap can not be null");
        this.attributeOverridesMap = attributeOverridesMap;
    }

    public void setUserAttributeOverride(String uid, Map<String, Object> attributes) {
        Map multivaluedAttributes = MultivaluedPersonAttributeUtils.toMultivaluedMap(attributes);
        this.attributeOverridesMap.put(uid, multivaluedAttributes);
    }

    public void removeUserAttributeOverride(String uid) {
        this.attributeOverridesMap.remove(uid);
    }

    public IPersonAttributes getPerson(String uid) {
        IPersonAttributes person = this.delegatePersonAttributeDao.getPerson(uid);
        if (person == null) {
            return person;
        }
        return this.getOverriddenPerson(person);
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        Set people = this.delegatePersonAttributeDao.getPeopleWithMultivaluedAttributes(query);
        if (people == null) {
            return null;
        }
        LinkedHashSet<IPersonAttributes> modifiedPeople = new LinkedHashSet<IPersonAttributes>();
        for (IPersonAttributes person : people) {
            IPersonAttributes mergedPerson = this.getOverriddenPerson(person);
            modifiedPeople.add(mergedPerson);
        }
        return modifiedPeople;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.delegatePersonAttributeDao.getPossibleUserAttributeNames();
    }

    public Set<String> getAvailableQueryAttributes() {
        return this.delegatePersonAttributeDao.getAvailableQueryAttributes();
    }

    protected IPersonAttributes getOverriddenPerson(IPersonAttributes person) {
        String name = person.getName();
        if (name == null) {
            this.logger.info((Object)("IPerson '" + person + "' has no name and cannot have attributes overriden"));
            return person;
        }
        Map attributeOverrides = (Map)this.attributeOverridesMap.get(name);
        if (attributeOverrides == null) {
            return person;
        }
        Map personAttributes = person.getAttributes();
        LinkedHashMap mutablePersonAttributes = new LinkedHashMap(personAttributes);
        Map mergedAttributes = this.attributeMerger.mergeAttributes(mutablePersonAttributes, attributeOverrides);
        return new NamedPersonImpl(name, mergedAttributes);
    }
}

