/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rdbm;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.rdbm.DatabaseMetaDataImpl;
import org.jasig.portal.rdbm.IDatabaseMetadata;
import org.jasig.portal.rdbm.IJoinQueryString;
import org.jasig.portal.rdbm.JoinQueryString;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseMetaDataImpl
implements IDatabaseMetadata,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(DatabaseMetaDataImpl.class);
    private static final JoinQueryString jdbcDb = new JdbcDb("{oj UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID} WHERE");
    private static final JoinQueryString postgreSQLDb = new PostgreSQLDb("UP_USER LEFT OUTER JOIN UP_USER_LAYOUT ON UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID WHERE");
    private static final JoinQueryString oracleDb = new OracleDb("UP_USER, UP_USER_LAYOUT WHERE UP_USER.USER_ID = UP_USER_LAYOUT.USER_ID(+) AND");
    private static final JoinQueryString[] joinTests = new JoinQueryString[]{oracleDb, postgreSQLDb, jdbcDb};
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;
    private IJoinQueryString joinTest = null;
    private boolean dbmdSupportsOuterJoins = false;
    private boolean portalTablesExist = false;
    private boolean useTSWrapper = false;
    private boolean useToDate = false;
    private String databaseProductName = null;
    private String databaseProductVersion = null;
    private String driverName = null;
    private String driverVersion = null;
    private String userName = null;
    private String dbUrl = null;

    public DatabaseMetaDataImpl(DataSource ds, PlatformTransactionManager transactionManager) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        this.dataSource = ds;
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.setReadOnly(true);
        this.transactionTemplate.afterPropertiesSet();
        this.runDatabaseTests();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.toString());
        }
    }

    private void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occured while closing a connection.", (Throwable)e);
        }
    }

    public final IJoinQueryString getJoinQuery() {
        return this.joinTest;
    }

    public final boolean supportsOuterJoins() {
        return this.joinTest != null;
    }

    public final boolean supportsTransactions() {
        return true;
    }

    public final boolean supportsPreparedStatements() {
        return true;
    }

    public String getJdbcDriver() {
        return this.driverName;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getJdbcDriverVersion() {
        return this.driverVersion;
    }

    public String getJdbcUrl() {
        return this.dbUrl;
    }

    public String getJdbcUser() {
        return this.userName;
    }

    public String sqlTimeStamp() {
        return this.sqlTimeStamp(System.currentTimeMillis());
    }

    public String sqlTimeStamp(long date) {
        StringBuffer sqlTS = new StringBuffer();
        if (this.useToDate) {
            SimpleDateFormat oracleToDate = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
            sqlTS.append("TO_DATE('");
            sqlTS.append(oracleToDate.format(new Date(date)));
            sqlTS.append("', 'YYYY MM DD HH24:MI:SS')");
        } else if (this.useTSWrapper) {
            sqlTS.append("{ts '");
            sqlTS.append(new Timestamp(date).toString());
            sqlTS.append("'}");
        } else {
            sqlTS.append("'");
            sqlTS.append(new Timestamp(date).toString());
            sqlTS.append("'");
        }
        return sqlTS.toString();
    }

    public String sqlTimeStamp(Date date) {
        if (date == null) {
            return "NULL";
        }
        return this.sqlTimeStamp(date.getTime());
    }

    public String toString() {
        StringBuilder dbInfo = new StringBuilder();
        dbInfo.append(this.databaseProductName);
        dbInfo.append(" (");
        dbInfo.append(this.databaseProductVersion);
        dbInfo.append(") / ");
        dbInfo.append(this.driverName);
        dbInfo.append(" (");
        dbInfo.append(this.driverVersion);
        dbInfo.append(") database/driver");
        dbInfo.append("\n");
        dbInfo.append("    Connected To: ");
        dbInfo.append(this.dbUrl);
        dbInfo.append("\n");
        if (this.portalTablesExist) {
            dbInfo.append("    Supports:");
            dbInfo.append("\n");
            dbInfo.append("        Outer Joins:          ");
            dbInfo.append(this.supportsOuterJoins());
            dbInfo.append("\n");
            dbInfo.append("        {ts metasyntax:       ");
            dbInfo.append(this.useTSWrapper);
            dbInfo.append("\n");
            dbInfo.append("        TO_DATE():            ");
            dbInfo.append(this.useToDate);
        } else {
            dbInfo.append("    WARNING: uPortal tables do no exist, not all meta-data tests were executed.");
        }
        return dbInfo.toString();
    }

    private void runDatabaseTests() {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            this.getMetaData(conn);
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
            this.testDatabaseInitialized(jdbcTemplate);
            if (this.portalTablesExist) {
                this.testOuterJoins(jdbcTemplate);
                this.testTimeStamp(jdbcTemplate);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Error during database initialization. ", (Throwable)e);
            throw new DataAccessResourceFailureException("Error during database initialization. ", (Throwable)e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    private void getMetaData(Connection conn) {
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            this.databaseProductName = dmd.getDatabaseProductName();
            this.databaseProductVersion = dmd.getDatabaseProductVersion();
            this.driverName = dmd.getDriverName();
            this.driverVersion = dmd.getDriverVersion();
            this.userName = dmd.getUserName();
            this.dbUrl = dmd.getURL();
            this.dbmdSupportsOuterJoins = dmd.supportsOuterJoins();
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Error getting database meta data.", (Throwable)sqle);
        }
    }

    private void testDatabaseInitialized(SimpleJdbcTemplate jdbcTemplate) {
        try {
            jdbcTemplate.queryForInt("SELECT COUNT(USER_ID) FROM UP_USER", new Object[0]);
            this.portalTablesExist = true;
        }
        catch (BadSqlGrammarException bsge) {
            LOG.warn((Object)"The uPortal database is not initialized, the database tests will not be performed.");
        }
    }

    private void testOuterJoins(SimpleJdbcTemplate jdbcTemplate) {
        if (this.dbmdSupportsOuterJoins) {
            for (JoinQueryString joinQueryString : joinTests) {
                String joinTestQuery = "SELECT COUNT(UP_USER.USER_ID) FROM " + joinQueryString.getTestJoin() + " UP_USER.USER_ID=0";
                try {
                    this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
                    this.joinTest = joinQueryString;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Using join test: " + this.joinTest.getClass().getName()));
                    break;
                }
                catch (Exception e) {
                    String logMessage = "Join test failed: " + joinQueryString.getClass().getName() + " on statement: '" + joinTestQuery + "':";
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)logMessage, (Throwable)e);
                }
            }
        }
    }

    private void testTimeStamp(SimpleJdbcTemplate jdbcTemplate) {
        block5: {
            try {
                String timeStampTestQuery = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT={ts '2001-01-01 00:00:00.0'} AND USER_ID = 0";
                jdbcTemplate.queryForList("SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT={ts '2001-01-01 00:00:00.0'} AND USER_ID = 0", new Object[0]);
                this.useTSWrapper = true;
            }
            catch (DataAccessException dae1) {
                String logMessage1 = "Error running {ts } test.";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error running {ts } test.", (Throwable)dae1);
                }
                try {
                    String toDateTestQuery = "SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT>TO_DATE('2001 01 01 00:00', 'YYYY MM DD HH24:MI:SS') AND USER_ID=0";
                    jdbcTemplate.queryForList("SELECT USER_ID FROM UP_USER WHERE LST_CHAN_UPDT_DT>TO_DATE('2001 01 01 00:00', 'YYYY MM DD HH24:MI:SS') AND USER_ID=0", new Object[0]);
                    this.useToDate = true;
                }
                catch (DataAccessException dae2) {
                    String logMessage2 = "Error running TO_DATE() test.";
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Error running TO_DATE() test.", (Throwable)dae2);
                }
            }
        }
    }
}

