/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jasig.portal.rendering.PipelineEventReader;

public class PipelineEventReaderImpl<R, E>
implements PipelineEventReader<R, E> {
    private final R eventReader;
    private final Map<String, String> outputProperties;

    public PipelineEventReaderImpl(R eventReader) {
        this.eventReader = eventReader;
        this.outputProperties = new LinkedHashMap();
    }

    public PipelineEventReaderImpl(R eventReader, Map<String, String> outputProperties) {
        this.eventReader = eventReader;
        this.outputProperties = new LinkedHashMap<String, String>(outputProperties);
    }

    public Iterator<E> iterator() {
        return (Iterator)this.eventReader;
    }

    public R getEventReader() {
        return (R)this.eventReader;
    }

    public String setOutputProperty(String name, String value) {
        if (value == null) {
            return (String)this.outputProperties.remove(name);
        }
        return this.outputProperties.put(name, value);
    }

    public String getOutputProperty(String name) {
        return (String)this.outputProperties.get(name);
    }

    public Map<String, String> getOutputProperties() {
        return Collections.unmodifiableMap(this.outputProperties);
    }

    public int hashCode() {
        return this.eventReader.hashCode();
    }

    public boolean equals(Object obj) {
        return this.eventReader.equals(obj);
    }

    public String toString() {
        return this.eventReader.toString();
    }
}

