/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.rendering.AttributeSource;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletWindowAttributeSource
implements AttributeSource,
BeanNameAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newFactory();
    private String name;
    private IPortletWindowRegistry portletWindowRegistry;

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public final Iterator<Attribute> getAdditionalAttributes(HttpServletRequest request, HttpServletResponse response, StartElement event) {
        QName eventName = event.getName();
        String localEventName = eventName.getLocalPart();
        if (!"channel".equals(localEventName)) {
            return null;
        }
        Tuple portletWindowAndElement = this.portletWindowRegistry.getPortletWindow(request, event);
        if (portletWindowAndElement == null) {
            this.logger.warn("No IPortletWindow could be found or created for element: " + event);
            return null;
        }
        IPortletWindow portletWindow = (IPortletWindow)portletWindowAndElement.first;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        WindowState windowState = portletWindow.getWindowState();
        Attribute windowStateAttribute = this.xmlEventFactory.createAttribute("windowState", windowState.toString());
        attributes.add(windowStateAttribute);
        PortletMode portletMode = portletWindow.getPortletMode();
        Attribute portletModeAttribute = this.xmlEventFactory.createAttribute("portletMode", portletMode.toString());
        attributes.add(portletModeAttribute);
        return attributes.iterator();
    }

    public final CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        Set portletWindows = this.portletWindowRegistry.getAllLayoutPortletWindows(request);
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)this.name);
        for (IPortletWindow portletWindow : portletWindows) {
            if (portletWindow != null) {
                IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
                WindowState windowState = portletWindow.getWindowState();
                PortletMode portletMode = portletWindow.getPortletMode();
                cacheKeyBuilder.addAll(new Serializable[]{portletWindowId, windowState.toString(), portletMode.toString()});
                continue;
            }
            this.logger.warn("portletWindowRegistry#getAllLayoutPortletWindows() returned a null portletWindow");
        }
        return cacheKeyBuilder.build();
    }
}

