/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSourceAdapter;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocaleTransformerConfigurationSource
extends TransformerConfigurationSourceAdapter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUserInstanceManager userInstanceManager;

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    private LocaleManager getLocaleManager(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        return userInstance.getLocaleManager();
    }

    public Map<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response) {
        LocaleManager localeManager = this.getLocaleManager(request);
        Locale[] locales = localeManager.getLocales();
        if (locales != null && locales.length > 0 && locales[0] != null) {
            String locale = locales[0].toString();
            String xslLocale = locale.replace('_', '-');
            this.logger.debug("Setting USER_LANG to {}", (Object)xslLocale);
            return Collections.singletonMap("USER_LANG", xslLocale);
        }
        return null;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        LocaleManager localeManager = this.getLocaleManager(request);
        Locale[] locales = localeManager.getLocales();
        if (locales != null && locales.length > 0 && locales[0] != null) {
            String locale = locales[0].toString();
            String xslLocale = locale.replace('_', '-');
            return CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{xslLocale});
        }
        return null;
    }
}

