/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class EntitiesRESTController {
    private IGroupListHelper groupListHelper;

    @Autowired
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @PostAuthorize(value="hasPermission(returnObject, 'VIEW')")
    @RequestMapping(value={"/entities/{entityType}/{entityId}.json"}, method={RequestMethod.GET})
    public JsonEntityBean findEntity(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityType") String entityType, @PathVariable(value="entityId") String entityId) {
        JsonEntityBean result = this.groupListHelper.getEntity(entityType, entityId, true);
        return result;
    }

    @PostFilter(value="hasPermission(filterObject, 'VIEW')")
    @RequestMapping(value={"/entities.json"}, method={RequestMethod.GET})
    public Set<JsonEntityBean> doSearch(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="q") String query, @RequestParam(value="entityType[]") List<String> entityTypes) {
        HashSet<JsonEntityBean> results = new HashSet<JsonEntityBean>();
        for (String entityType : entityTypes) {
            Set entities = this.groupListHelper.search(entityType, query);
            results.addAll(entities);
        }
        return results;
    }
}

