/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.xml.StaxUtils;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.stream.BufferedXMLEventReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImportExportController {
    private static final String OWNER = "UP_SYSTEM";
    private static final String EXPORT_PERMISSION = "EXPORT_ENTITY";
    private static final String DELETE_PERMISSION = "DELETE_ENTITY";
    final Log log = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;
    private IPortalDataHandlerService portalDataHandlerService;
    private XmlUtilities xmlUtilities;

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalDataHandlerService(IPortalDataHandlerService portalDataHandlerService) {
        this.portalDataHandlerService = portalDataHandlerService;
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public void importEntity(@RequestParam(value="file") MultipartFile entityFile, HttpServletRequest request, HttpServletResponse response) throws IOException, XMLStreamException {
        BufferedXMLEventReader bufferedXmlEventReader = this.createSourceXmlEventReader(entityFile);
        PortalDataKey portalDataKey = this.getPortalDataKey(bufferedXmlEventReader);
        IPerson person = this.personManager.getPerson(request);
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (!ap.hasPermission(OWNER, "IMPORT_ENTITY", portalDataKey.getName().getLocalPart())) {
            response.setStatus(401);
            return;
        }
        this.portalDataHandlerService.importData((Source)new StAXSource((XMLEventReader)bufferedXmlEventReader));
        response.setStatus(200);
    }

    protected BufferedXMLEventReader createSourceXmlEventReader(MultipartFile multipartFile) throws IOException {
        XMLEventReader xmlEventReader;
        InputStream inputStream = multipartFile.getInputStream();
        String name = multipartFile.getOriginalFilename();
        XMLInputFactory xmlInputFactory = this.xmlUtilities.getXmlInputFactory();
        try {
            xmlEventReader = xmlInputFactory.createXMLEventReader(name, inputStream);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XML Event Reader for data Source", e);
        }
        return new BufferedXMLEventReader(xmlEventReader, -1);
    }

    protected PortalDataKey getPortalDataKey(BufferedXMLEventReader bufferedXmlEventReader) {
        StartElement rootElement = StaxUtils.getRootElement((XMLEventReader)bufferedXmlEventReader);
        PortalDataKey portalDataKey = new PortalDataKey(rootElement);
        bufferedXmlEventReader.reset();
        return portalDataKey;
    }

    @RequestMapping(value={"/entity/{entityType}/{entityId}"}, method={RequestMethod.DELETE})
    public void deleteEntity(@PathVariable(value="entityType") String entityType, @PathVariable(value="entityId") String entityId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IPerson person = this.personManager.getPerson(request);
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (!ap.hasPermission(OWNER, DELETE_PERMISSION, entityType)) {
            response.setStatus(401);
            return;
        }
        this.portalDataHandlerService.deleteData(entityType, entityId);
        response.setStatus(204);
    }

    @RequestMapping(value={"/entity/{entityType}/{entityId}"}, method={RequestMethod.GET})
    public void exportEntity(@PathVariable(value="entityId") String entityId, @PathVariable(value="entityType") String entityType, @RequestParam(value="download", required=false) boolean download, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IPerson person = this.personManager.getPerson(request);
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (!ap.hasPermission(OWNER, EXPORT_PERMISSION, entityType)) {
            response.setStatus(401);
            return;
        }
        StringWriter exportBuffer = new StringWriter();
        String fileName = this.portalDataHandlerService.exportData(entityType, entityId, (Result)new StreamResult(exportBuffer));
        if (download) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "." + entityType + ".xml\"");
        }
        PrintWriter responseWriter = response.getWriter();
        responseWriter.print(exportBuffer.getBuffer());
    }
}

