/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.util.ArrayList;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.rest.layout.LayoutPortlet;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

@Controller
public class LayoutRESTController {
    protected final Log log = LogFactory.getLog(this.getClass());
    IUserLayoutStore userLayoutStore;
    IPersonManager personManager;
    private IPortalUrlProvider urlProvider;
    private IUserInstanceManager userInstanceManager;
    private IPortletDefinitionDao portletDao;

    @Autowired(required=true)
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    @Autowired(required=true)
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired(required=true)
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.urlProvider = urlProvider;
    }

    @Autowired(required=true)
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired(required=true)
    public void setPortletDao(IPortletDefinitionDao portletDao) {
        this.portletDao = portletDao;
    }

    @RequestMapping(value={"/layoutDoc"}, method={RequestMethod.GET})
    public ModelAndView getRESTController(HttpServletRequest request, HttpServletResponse response) {
        IPerson person = this.personManager.getPerson(request);
        ArrayList<LayoutPortlet> portlets = new ArrayList<LayoutPortlet>();
        try {
            IUserInstance ui = this.userInstanceManager.getUserInstance(request);
            IUserPreferencesManager upm = ui.getPreferencesManager();
            IUserProfile profile = upm.getUserProfile();
            DistributedUserLayout userLayout = this.userLayoutStore.getUserLayout(person, profile);
            Document document = userLayout.getLayout();
            NodeList portletNodes = document.getElementsByTagName("channel");
            for (int i = 0; i < portletNodes.getLength(); ++i) {
                try {
                    IPortalUrlBuilder portalUrlBuilder;
                    IPortletWindowId targetPortletWindowId;
                    LayoutPortlet portlet = new LayoutPortlet();
                    NamedNodeMap attributes = portletNodes.item(i).getAttributes();
                    portlet.setTitle(attributes.getNamedItem("title").getNodeValue());
                    portlet.setDescription(attributes.getNamedItem("description").getNodeValue());
                    portlet.setNodeId(attributes.getNamedItem("ID").getNodeValue());
                    IPortletDefinition def = this.portletDao.getPortletDefinitionByFname(attributes.getNamedItem("fname").getNodeValue());
                    IPortletDefinitionParameter iconParam = def.getParameter("iconUrl");
                    if (iconParam != null) {
                        portlet.setIconUrl(iconParam.getValue());
                    }
                    if ((targetPortletWindowId = (portalUrlBuilder = this.urlProvider.getPortalUrlBuilderByLayoutNode(request, attributes.getNamedItem("ID").getNodeValue(), UrlType.RENDER)).getTargetPortletWindowId()) != null) {
                        IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(targetPortletWindowId);
                        portletUrlBuilder.setWindowState(WindowState.MAXIMIZED);
                    }
                    portlet.setUrl(portalUrlBuilder.getUrlString());
                    portlets.add(portlet);
                    continue;
                }
                catch (Exception e) {
                    this.log.warn((Object)"Exception construction JSON representation of mobile portlet", (Throwable)e);
                }
            }
            ModelAndView mv = new ModelAndView();
            mv.addObject("layout", portlets);
            mv.setViewName("json");
            return mv;
        }
        catch (Exception e) {
            this.log.error((Object)"Error retrieving user layout document", (Throwable)e);
            return null;
        }
    }
}

