/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.filter.OncePerRequestFilter;

@Service(value="threadNamingRequestFilter")
public class ThreadNamingRequestFilter
extends OncePerRequestFilter {
    private final ThreadLocal<String> originalThreadNameLocal = new ThreadLocal();
    private IPersonManager personManager;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public void updateCurrentUsername(String newUsername) {
        String originalThreadName = (String)this.originalThreadNameLocal.get();
        if (originalThreadName != null && newUsername != null) {
            Thread currentThread = Thread.currentThread();
            String threadName = this.getThreadName(originalThreadName, newUsername);
            currentThread.setName(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String username = this.getUserName(request);
        if (username == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            try {
                this.originalThreadNameLocal.set(originalThreadName);
                String threadName = this.getThreadName(originalThreadName, username);
                currentThread.setName(threadName);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                currentThread.setName(originalThreadName);
                this.originalThreadNameLocal.remove();
            }
        }
    }

    protected String getThreadName(String originalThreadName, String newUsername) {
        return originalThreadName + "-" + newUsername;
    }

    protected String getUserName(HttpServletRequest request) {
        IPerson person = this.personManager.getPerson(request);
        if (person == null) {
            return null;
        }
        return person.getUserName();
    }
}

