/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IParentAwareSecurityContext;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.IStringEncryptionService;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.CacheSecurityContext;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.spring.locator.PasswordEncryptionServiceLocator;

class CacheSecurityContext
extends ChainingSecurityContext
implements ISecurityContext,
IParentAwareSecurityContext {
    private static final long serialVersionUID = 1L;
    private static final int CACHESECURITYAUTHTYPE = 65283;
    private static final Log LOG = LogFactory.getLog(CacheSecurityContext.class);
    private ISecurityContext parentContext;
    private byte[] cachedcredentials;

    CacheSecurityContext() {
    }

    public int getAuthType() {
        return 65283;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        String msg = "Contexts that implement IParentAwareSecurityContext must authenticate through authenticate(ISecurityContext)";
        throw new UnsupportedOperationException(msg);
    }

    public void authenticate(ISecurityContext parent) throws PortalSecurityException {
        this.parentContext = parent;
        if (!this.parentContext.isAuthenticated()) {
            return;
        }
        if (this.myOpaqueCredentials.credentialstring != null) {
            IStringEncryptionService encryptionService = PasswordEncryptionServiceLocator.getPasswordEncryptionService();
            String encryptedPassword = encryptionService.encrypt(new String(this.myOpaqueCredentials.credentialstring));
            byte[] encryptedPasswordBytes = encryptedPassword.getBytes();
            this.cachedcredentials = new byte[encryptedPasswordBytes.length];
            System.arraycopy(encryptedPasswordBytes, 0, this.cachedcredentials, 0, encryptedPasswordBytes.length);
            LOG.info((Object)"Credentials successfully cached");
        }
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.parentContext != null && this.parentContext.isAuthenticated()) {
            CacheOpaqueCredentials oc = new CacheOpaqueCredentials(this, null);
            oc.setCredentials(this.cachedcredentials);
            return oc;
        }
        return null;
    }
}

