/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.AbstractPersonManager;
import org.jasig.portal.security.provider.RemoteUserSecurityContext;

public class RemoteUserPersonManager
extends AbstractPersonManager {
    private static final Log log = LogFactory.getLog(RemoteUserPersonManager.class);
    public static final String REMOTE_USER = "remote_user";

    public IPerson getPerson(HttpServletRequest request) throws PortalSecurityException {
        HttpSession session = request.getSession(false);
        IPerson person = null;
        if (session != null && (person = (IPerson)session.getAttribute("org.jasig.portal.security.IPerson")) != null) {
            return person;
        }
        try {
            person = PersonFactory.createGuestPerson();
            String remoteUser = request.getRemoteUser();
            ISecurityContext context = null;
            Enumeration subContexts = null;
            boolean remoteUserSecurityContextExists = false;
            context = person.getSecurityContext();
            if (context != null) {
                subContexts = context.getSubContexts();
            }
            if (subContexts != null) {
                while (subContexts.hasMoreElements()) {
                    ISecurityContext ctx = (ISecurityContext)subContexts.nextElement();
                    if (!(ctx instanceof RemoteUserSecurityContext)) continue;
                    RemoteUserSecurityContext remoteuserctx = (RemoteUserSecurityContext)ctx;
                    remoteuserctx.setRemoteUser(remoteUser);
                    remoteUserSecurityContextExists = true;
                }
            }
            if (!remoteUserSecurityContextExists) {
                RemoteUserSecurityContext remoteuserctx = new RemoteUserSecurityContext(remoteUser);
                person.setSecurityContext((ISecurityContext)remoteuserctx);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception creating person for request " + request), (Throwable)e);
        }
        if (session != null) {
            session.setAttribute("org.jasig.portal.security.IPerson", (Object)person);
        }
        return person;
    }
}

