/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.cas;

import java.security.Principal;
import org.jasig.cas.client.util.AssertionHolder;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.security.provider.cas.CasProxyTicketAcquisitionException;
import org.jasig.portal.security.provider.cas.ICasSecurityContext;

public class CasAssertionSecurityContext
extends ChainingSecurityContext
implements ICasSecurityContext {
    private Assertion assertion;

    public int getAuthType() {
        return 5889;
    }

    protected void postAuthenticate(Assertion assertion) {
    }

    public final void authenticate() throws PortalSecurityException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Authenticating user via CAS.");
        }
        this.isauth = false;
        this.assertion = AssertionHolder.getAssertion();
        if (this.assertion != null) {
            this.myPrincipal.setUID(this.assertion.getPrincipal().getName());
            this.isauth = true;
            this.log.debug("CASContext authenticated [" + this.myPrincipal.getUID() + "] using assertion [" + this.assertion + "]");
            this.postAuthenticate(this.assertion);
        }
        this.myAdditionalDescriptor = null;
        super.authenticate();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Finished CAS Authentication");
        }
    }

    public final String getCasServiceToken(String target) throws CasProxyTicketAcquisitionException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Attempting to retrieve proxy ticket for target [" + target + "] by using CAS Assertion [" + this.assertion + "]");
        }
        if (this.assertion == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No Assertion found for user.  Returning null Proxy Ticket.");
            }
            return null;
        }
        String proxyTicket = this.assertion.getPrincipal().getProxyTicketFor(target);
        if (proxyTicket == null) {
            this.log.error("Failed to retrieve proxy ticket for assertion [" + this.assertion + "].  Is the PGT still valid?");
            throw new CasProxyTicketAcquisitionException(target, (Principal)this.assertion.getPrincipal());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Returning from Proxy Ticket Request with ticket [" + proxyTicket + "]");
        }
        return proxyTicket;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" assertion:");
        builder.append(this.assertion);
        return builder.toString();
    }
}

