/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MultiThreadedHttpConnectionManagerFactoryBean
extends AbstractFactoryBean<MultiThreadedHttpConnectionManager> {
    private int maxTotalConnections = 200;
    private int defaultMaxConnectionsPerHost = 20;
    private int connectionTimeout = 5000;
    private int soTimeout = 2000;

    @Value(value="${org.jasig.portal.services.HttpClientManager.poolSize:200}")
    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    @Value(value="${org.jasig.portal.services.HttpClientManager.hostConnections:20}")
    public void setDefaultMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    @Value(value="${org.jasig.portal.services.HttpClientManager.connectionTimeout:5000}")
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Value(value="${org.jasig.portal.services.HttpClientManager.readTimeout:2000}")
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Class<?> getObjectType() {
        return MultiThreadedHttpConnectionManager.class;
    }

    protected MultiThreadedHttpConnectionManager createInstance() throws Exception {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams pars = multiThreadedHttpConnectionManager.getParams();
        pars.setConnectionTimeout(this.connectionTimeout);
        pars.setSoTimeout(this.soTimeout);
        pars.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        pars.setMaxTotalConnections(this.maxTotalConnections);
        pars.setDefaultMaxConnectionsPerHost(this.defaultMaxConnectionsPerHost);
        return multiThreadedHttpConnectionManager;
    }

    protected void destroyInstance(MultiThreadedHttpConnectionManager instance) throws Exception {
        instance.shutdown();
    }
}

