/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.entityproperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.entityproperties.IEntityPropertyFinder;
import org.jasig.portal.spring.locator.PersonAttributeDaoLocator;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;

public class PersonDirPropertyFinder
implements IEntityPropertyFinder {
    private static final Log log = LogFactory.getLog(PersonDirPropertyFinder.class);
    private Class<IPerson> person = IPerson.class;
    private IPersonAttributeDao pa = PersonAttributeDaoLocator.getPersonAttributeDao();
    private Map<String, Map<String, List<Object>>> cache = new ReferenceMap(0, 1, 120, 0.75f, true);

    public String[] getPropertyNames(EntityIdentifier entityID) {
        String[] r = new String[]{};
        if (entityID.getType().equals(this.person)) {
            Map properties = this.getPropertiesHash(entityID);
            Set propertyNames = properties.keySet();
            r = propertyNames.toArray(r);
        }
        return r;
    }

    public String getProperty(EntityIdentifier entityID, String name) {
        String r = null;
        if (entityID.getType().equals(this.person)) {
            Map properties = this.getPropertiesHash(entityID);
            List values = (List)properties.get(name);
            StringBuilder sb = new StringBuilder();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                sb.append(value);
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            r = sb.toString();
        }
        return r;
    }

    protected Map<String, List<Object>> getPropertiesHash(EntityIdentifier entityID) {
        String entityIdKey = entityID.getKey();
        Map ht = (Map)this.cache.get(entityIdKey);
        if (ht == null) {
            try {
                IPersonAttributes personAttributes = this.pa.getPerson(entityIdKey);
                ht = personAttributes.getAttributes();
            }
            catch (Exception e) {
                log.error((Object)("Error getting properties hash for entityID [" + entityID + "]"), (Throwable)e);
                ht = Collections.emptyMap();
            }
            this.cache.put(entityIdKey, ht);
        }
        return new HashMap<String, List<Object>>(ht);
    }
}

