/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.shell;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.jasig.portal.shell.SpringBinding;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalShell {
    static final Logger LOGGER = LoggerFactory.getLogger(PortalShell.class);

    protected static Options getOptions() {
        Options options = new Options();
        options.addOption(new Option("s", "script", true, "Groovy script to execute in the uPortal Shell."));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine commandLine;
        Options options = PortalShell.getOptions();
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            PortalShell.printHelp((Options)options);
            return;
        }
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        try {
            SpringBinding binding = new SpringBinding(applicationContext);
            binding.setVariable("logger", (Object)LOGGER);
            if (commandLine.hasOption("script")) {
                String scriptName = commandLine.getOptionValue("script");
                File scriptFile = PortalShell.getAbsoluteFile((String)scriptName);
                CompilerConfiguration conf = new CompilerConfiguration(System.getProperties());
                GroovyShell shell = new GroovyShell((Binding)binding, conf);
                shell.run(scriptFile, args);
            } else {
                Groovysh shell = new Groovysh((Binding)binding, new IO());
                shell.run(new String[0]);
            }
        }
        finally {
            if (applicationContext instanceof DisposableBean) {
                ((DisposableBean)applicationContext).destroy();
            }
        }
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.err);
        formatter.printHelp(pw, 74, "java " + PortalShell.class.getName(), null, options, 1, 3, null, true);
        pw.flush();
    }

    protected static File getAbsoluteFile(String filePath) {
        File file = FileUtils.isAbsolutePath((String)filePath) ? new File(filePath) : new File(new File(System.getProperty("user.dir")), filePath);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }
}

