/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.security.preauth;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.portlets.swapper.IdentitySwapperPrincipal;
import org.jasig.portal.portlets.swapper.IdentitySwapperSecurityContext;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.IdentitySwapperManager;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.spring.security.PortalPersonUserDetails;
import org.jasig.portal.utils.ResourceLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class PortalPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    protected final Log swapperLog = LogFactory.getLog((String)"org.jasig.portal.portlets.swapper");
    private String loginPath = "/Login";
    private String logoutPath = "/Logout";
    protected HashMap<String, String> credentialTokens;
    protected HashMap<String, String> principalTokens;
    protected Authentication authenticationService = null;
    private IPersonManager personManager;
    private IdentitySwapperManager identitySwapperManager;

    @Autowired
    public void setIdentitySwapperManager(IdentitySwapperManager identitySwapperManager) {
        this.identitySwapperManager = identitySwapperManager;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setAuthenticationService(Authentication authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.credentialTokens = new HashMap(1);
        this.principalTokens = new HashMap(1);
        try {
            Properties props = ResourceLoader.getResourceAsProperties(this.getClass(), (String)"/properties/security.properties");
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String key;
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                if (propName.startsWith("credentialToken.")) {
                    key = propName.substring(16);
                    this.credentialTokens.put(key, propValue);
                }
                if (!propName.startsWith("principalToken.")) continue;
                key = propName.substring(15);
                this.principalTokens.put(key, propValue);
            }
        }
        catch (PortalException pe) {
            this.logger.error((Object)"LoginServlet::static ", (Throwable)pe);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"LoginServlet::static ", (Throwable)ioe);
        }
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String currentPath = httpServletRequest.getServletPath();
        if (this.loginPath.equals(currentPath)) {
            SecurityContextHolder.clearContext();
            this.doPortalAuthentication((HttpServletRequest)request);
            chain.doFilter(request, response);
        } else if (this.logoutPath.equals(currentPath)) {
            SecurityContextHolder.clearContext();
            chain.doFilter(request, response);
        } else {
            super.doFilter(request, response, chain);
        }
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        IPerson person = this.personManager.getPerson(request);
        return person.getSecurityContext();
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        IPerson person = this.personManager.getPerson(request);
        PortalPersonUserDetails details = new PortalPersonUserDetails(person);
        return details;
    }

    private void doPortalAuthentication(HttpServletRequest request) {
        HttpSession s;
        boolean swap;
        String originalUid;
        String targetUid;
        block15: {
            targetUid = null;
            originalUid = null;
            swap = false;
            if (request.isRequestedSessionIdValid()) {
                try {
                    IPerson person;
                    s = request.getSession(false);
                    if (s != null) {
                        originalUid = this.identitySwapperManager.getOriginalUsername(s);
                    }
                    if (originalUid == null) {
                        targetUid = this.identitySwapperManager.getTargetUsername(s);
                        if (targetUid != null) {
                            person = this.personManager.getPerson(request);
                            originalUid = person.getName();
                            swap = true;
                        }
                    } else {
                        person = this.personManager.getPerson(request);
                        targetUid = person.getName();
                    }
                    if (s != null) {
                        s.invalidate();
                    }
                }
                catch (IllegalStateException ise) {
                    if (!this.logger.isTraceEnabled()) break block15;
                    this.logger.trace((Object)"LoginServlet attempted to invalidate an already invalid session.", (Throwable)ise);
                }
            }
        }
        s = request.getSession(true);
        String requestedProfile = request.getParameter("profile");
        if (requestedProfile != null) {
            s.setAttribute("profileKey", (Object)requestedProfile);
        }
        IPerson person = null;
        try {
            HashMap credentials;
            HashMap principals;
            person = this.personManager.getPerson(request);
            if (targetUid != null && originalUid != null) {
                if (swap) {
                    this.swapperLog.warn((Object)("Swapping identity for '" + originalUid + "' to '" + targetUid + "'"));
                    this.identitySwapperManager.setOriginalUser(s, originalUid, targetUid);
                    person.setUserName(targetUid);
                } else {
                    this.swapperLog.warn((Object)("Reverting swapped identity from '" + targetUid + "' to '" + originalUid + "'"));
                    person.setUserName(originalUid);
                }
                IdentitySwapperPrincipal identitySwapperPrincipal = new IdentitySwapperPrincipal(person);
                IdentitySwapperSecurityContext identitySwapperSecurityContext = new IdentitySwapperSecurityContext((IPrincipal)identitySwapperPrincipal);
                person.setSecurityContext((ISecurityContext)identitySwapperSecurityContext);
                principals = new HashMap();
                credentials = new HashMap();
            } else {
                principals = this.getPropertyFromRequest(this.principalTokens, request);
                credentials = this.getPropertyFromRequest(this.credentialTokens, request);
            }
            this.authenticationService.authenticate(request, (Map)principals, (Map)credentials, person);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception authenticating the request", (Throwable)e);
            request.getSession(false).invalidate();
            request.getSession(true).setAttribute("up_authenticationError", (Object)Boolean.TRUE);
        }
    }

    private HashMap<String, String> getPropertyFromRequest(HashMap<String, String> tokens, HttpServletRequest request) {
        HashMap<String, String> retHash = new HashMap<String, String>(1);
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            String contextName = entry.getKey();
            String parmName = entry.getValue();
            String parmValue = null;
            if (request.getAttribute(parmName) != null) {
                try {
                    parmValue = (String)request.getAttribute(parmName);
                }
                catch (ClassCastException cce) {
                    String msg = "The request attribute '" + parmName + "' must be a String.";
                    throw new RuntimeException(msg, cce);
                }
            } else {
                parmValue = request.getParameter(parmName);
            }
            parmValue = "password".equals(parmName) ? (parmValue == null ? "" : parmValue) : (parmValue == null ? "" : parmValue).trim();
            String key = contextName.startsWith("root.") ? contextName.substring(5) : contextName;
            retHash.put(key, parmValue);
        }
        return retHash;
    }
}

