/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.spel;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.spel.IPortalSpELService;
import org.jasig.portal.spring.spel.PortalSpELServiceImpl;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.WebRequest;

@Service
public class PortalSpELServiceImpl
implements IPortalSpELService,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private Ehcache expressionCache;
    private BeanResolver beanResolver;
    private IPortalRequestUtils portalRequestUtils;
    private IUserInstanceManager userInstanceManager;

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Validate.notNull((Object)expressionParser);
        this.expressionParser = expressionParser;
    }

    @Autowired
    public void setExpressionCache(@Qualifier(value="SpELExpressionCache") Ehcache expressionCache) {
        this.expressionCache = expressionCache;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    public Expression parseExpression(String expressionString) throws ParseException {
        return this.parseCachedExpression(expressionString, null);
    }

    protected Expression parseCachedExpression(String expressionString, ParserContext parserContext) throws ParseException {
        if (this.expressionCache == null) {
            return this.parseExpression(expressionString, parserContext);
        }
        Element element = this.expressionCache.get((Serializable)((Object)expressionString));
        if (element != null) {
            return (Expression)element.getObjectValue();
        }
        Expression expression = this.parseExpression(expressionString, parserContext);
        element = new Element((Object)expressionString, (Object)expression);
        this.expressionCache.put(element);
        return expression;
    }

    protected Expression parseExpression(String expressionString, ParserContext parserContext) {
        if (parserContext == null) {
            return this.expressionParser.parseExpression(expressionString);
        }
        return this.expressionParser.parseExpression(expressionString, parserContext);
    }

    public String parseString(String expressionString, WebRequest request) {
        Expression expression = this.parseCachedExpression(expressionString, (ParserContext)TemplateParserContext.INSTANCE);
        return (String)this.getValue(expression, request, String.class);
    }

    public <T> T getValue(String expressionString, WebRequest request, Class<T> desiredResultType) {
        Expression expression = this.parseExpression(expressionString);
        return (T)this.getValue(expression, request, desiredResultType);
    }

    public <T> T getValue(Expression expression, WebRequest request, Class<T> desiredResultType) {
        EvaluationContext evaluationContext = this.getEvaluationContext(request);
        return (T)expression.getValue(evaluationContext, desiredResultType);
    }

    public Object getValue(String expressionString, WebRequest request) {
        Expression expression = this.parseExpression(expressionString);
        return this.getValue(expression, request);
    }

    public Object getValue(Expression expression, WebRequest request) {
        EvaluationContext evaluationContext = this.getEvaluationContext(request);
        return expression.getValue(evaluationContext);
    }

    protected EvaluationContext getEvaluationContext(WebRequest request) {
        HttpServletRequest httpRequest = this.portalRequestUtils.getOriginalPortalRequest(request);
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(httpRequest);
        IPerson person = userInstance.getPerson();
        SpELEnvironmentRoot root = new SpELEnvironmentRoot(request, person, null);
        StandardEvaluationContext context = new StandardEvaluationContext((Object)root);
        context.setBeanResolver(this.beanResolver);
        return context;
    }
}

