/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.tx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAware;
import org.jasig.portal.spring.tx.DialectAwareTransactionInterceptor;
import org.jasig.portal.spring.tx.TransactionManagerCachingTransactionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class DialectAwareTransactionInterceptor
extends TransactionManagerCachingTransactionInterceptor
implements HibernateConfigurationAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialectAwareTransactionInterceptor.class);
    private static final long serialVersionUID = 1L;
    private static final PlatformTransactionManager NOOP_TRANSACTION_MANAGER = new /* Unavailable Anonymous Inner Class!! */;
    private final Map<String, Class<? extends Dialect>> dialects = new ConcurrentHashMap();
    private TransactionAttributeSource wrappedTransactionAttributeSource;

    public boolean supports(String persistenceUnit) {
        return true;
    }

    public void setConfiguration(String persistenceUnit, DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration) {
        SessionFactoryImplementor sessionFactory = hibernateConfiguration.getSessionFactory();
        this.dialects.put(persistenceUnit, sessionFactory.getDialect().getClass());
    }

    public TransactionAttributeSource getTransactionAttributeSource() {
        TransactionAttributeSource tas = this.wrappedTransactionAttributeSource;
        if (tas == null) {
            TransactionAttributeSource transactionAttributeSource = super.getTransactionAttributeSource();
            if (this.dialects.isEmpty()) {
                return transactionAttributeSource;
            }
            this.wrappedTransactionAttributeSource = tas = new TransactionAttributeSourceWrapper(this.dialects, transactionAttributeSource);
        }
        return tas;
    }

    protected PlatformTransactionManager determineTransactionManager(TransactionAttribute txAttr) {
        if (txAttr instanceof SkipTransactionAttribute) {
            return NOOP_TRANSACTION_MANAGER;
        }
        return super.determineTransactionManager(txAttr);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

